/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import se.mickelus.tetra.blocks.workbench.TileEntityWorkbench;
import se.mickelus.tetra.network.BlockPosPacket;
import se.mickelus.tetra.util.CastOptional;

public class TweakWorkbenchPacket
extends BlockPosPacket {
    String slot;
    Map<String, Integer> tweaks;

    public TweakWorkbenchPacket() {
        this.tweaks = new HashMap<String, Integer>();
    }

    public TweakWorkbenchPacket(BlockPos pos, String slot, Map<String, Integer> tweaks) {
        super(pos);
        this.slot = slot;
        this.tweaks = tweaks;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        try {
            TweakWorkbenchPacket.writeString(this.slot, buffer);
        }
        catch (IOException e) {
            System.err.println("An error occurred when writing tweak packet to buffer");
        }
        buffer.writeInt(this.tweaks.size());
        this.tweaks.forEach((tweakKey, step) -> {
            try {
                TweakWorkbenchPacket.writeString(tweakKey, buffer);
                buffer.writeInt(step.intValue());
            }
            catch (IOException e) {
                System.err.println("An error occurred when writing tweak packet to buffer");
            }
        });
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        try {
            this.slot = TweakWorkbenchPacket.readString(buffer);
            int size = buffer.readInt();
            for (int i = 0; i < size; ++i) {
                this.tweaks.put(TweakWorkbenchPacket.readString(buffer), buffer.readInt());
            }
        }
        catch (IOException e) {
            System.err.println("An error occurred when reading tweak packet from buffer");
        }
    }

    @Override
    public void handle(EntityPlayer player) {
        CastOptional.cast(player.field_70170_p.func_175625_s(this.pos), TileEntityWorkbench.class).ifPresent(workbench -> workbench.tweak(player, this.slot, this.tweaks));
    }
}

