/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.advancements.BlockUseCriterion;
import se.mickelus.tetra.blocks.ITetraBlock;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.hammer.BlockHammerHead;
import se.mickelus.tetra.blocks.workbench.CraftWorkbenchPacket;
import se.mickelus.tetra.blocks.workbench.GuiHandlerWorkbench;
import se.mickelus.tetra.blocks.workbench.TileEntityWorkbench;
import se.mickelus.tetra.blocks.workbench.TweakWorkbenchPacket;
import se.mickelus.tetra.blocks.workbench.UpdateWorkbenchPacket;
import se.mickelus.tetra.blocks.workbench.action.ConfigActionImpl;
import se.mickelus.tetra.blocks.workbench.action.WorkbenchActionPacket;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.data.DataHandler;
import se.mickelus.tetra.items.TetraCreativeTabs;
import se.mickelus.tetra.network.GuiHandlerRegistry;
import se.mickelus.tetra.network.PacketHandler;

public class BlockWorkbench
extends TetraBlock
implements ITileEntityProvider {
    public static final PropertyEnum<Variant> propVariant = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    static final String unlocalizedName = "workbench";
    public static final AxisAlignedBB forgedAABB = new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 1.0, 1.0);
    public static BlockWorkbench instance;

    public BlockWorkbench() {
        super(Material.field_151575_d);
        this.setRegistryName(unlocalizedName);
        this.func_149663_c(unlocalizedName);
        GameRegistry.registerTileEntity(TileEntityWorkbench.class, (ResourceLocation)new ResourceLocation("tetra", unlocalizedName));
        this.func_149647_a(TetraCreativeTabs.getInstance());
        this.hasItem = true;
        instance = this;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(propVariant, (Comparable)((Object)Variant.wood)));
    }

    public static EnumActionResult upgradeWorkbench(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemStack)) {
            return EnumActionResult.FAIL;
        }
        if (world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150462_ai)) {
            world.func_184133_a(player, pos, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 1.0f, 0.5f);
            if (!world.field_72995_K) {
                world.func_175656_a(pos, instance.func_176223_P());
                BlockUseCriterion.trigger((EntityPlayerMP)player, instance.func_176223_P(), ItemStack.field_190927_a);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public void registerItem(IForgeRegistry<Item> registry) {
        ItemBlock item = new ItemBlock(this){

            public int func_77647_b(int damage) {
                return damage;
            }
        };
        item.setRegistryName(this.getRegistryName());
        registry.register((IForgeRegistryEntry)item);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            for (Variant variant : Variant.values()) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)variant.ordinal(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "variant=" + variant.toString()));
            }
        }
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> items) {
        if (((Object)((Object)TetraCreativeTabs.getInstance())).equals(creativeTabs)) {
            items.add((Object)new ItemStack((Block)this, 1, Variant.wood.ordinal()));
            if (ConfigHandler.generateFeatures) {
                items.add((Object)new ItemStack((Block)this, 1, Variant.forged.ordinal()));
            }
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        if (stack.func_77952_i() == Variant.forged.ordinal()) {
            tooltip.add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"forged_description", (Object[])new Object[0]));
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityWorkbench();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        player.openGui((Object)TetraMod.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (ConfigHandler.workbenchDropTable) {
            return Blocks.field_150462_ai.func_180660_a(Blocks.field_150462_ai.func_176223_P(), rand, fortune);
        }
        return super.func_180660_a(state, rand, fortune);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileentity));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return Blocks.field_150462_ai.getPickBlock(state, target, world, pos, player);
    }

    @Override
    public Collection<Capability> getCapabilities(World world, BlockPos pos, IBlockState blockState) {
        IBlockState accessoryBlockState = world.func_180495_p(pos.func_177972_a(EnumFacing.UP));
        if (accessoryBlockState.func_177230_c() instanceof ITetraBlock) {
            ITetraBlock block = (ITetraBlock)accessoryBlockState.func_177230_c();
            return block.getCapabilities(world, pos.func_177972_a(EnumFacing.UP), accessoryBlockState);
        }
        return Collections.emptyList();
    }

    @Override
    public int getCapabilityLevel(World world, BlockPos pos, IBlockState blockState, Capability capability) {
        IBlockState accessoryBlockState = world.func_180495_p(pos.func_177972_a(EnumFacing.UP));
        if (accessoryBlockState.func_177230_c() instanceof ITetraBlock) {
            ITetraBlock block = (ITetraBlock)accessoryBlockState.func_177230_c();
            return block.getCapabilityLevel(world, pos.func_177972_a(EnumFacing.UP), accessoryBlockState, capability);
        }
        return -1;
    }

    @Override
    public ItemStack onCraftConsumeCapability(World world, BlockPos pos, IBlockState blockState, ItemStack targetStack, EntityPlayer player, boolean consumeResources) {
        BlockPos topPos = pos.func_177972_a(EnumFacing.UP);
        if (world.func_180495_p(topPos).func_177230_c() instanceof BlockHammerHead) {
            BlockHammerHead hammer = (BlockHammerHead)world.func_180495_p(topPos).func_177230_c();
            return hammer.onCraftConsumeCapability(world, topPos, world.func_180495_p(topPos), targetStack, player, consumeResources);
        }
        return targetStack;
    }

    @Override
    public ItemStack onActionConsumeCapability(World world, BlockPos pos, IBlockState blockState, ItemStack targetStack, EntityPlayer player, boolean consumeResources) {
        BlockPos topPos = pos.func_177972_a(EnumFacing.UP);
        if (world.func_180495_p(topPos).func_177230_c() instanceof BlockHammerHead) {
            BlockHammerHead hammer = (BlockHammerHead)world.func_180495_p(topPos).func_177230_c();
            return hammer.onActionConsumeCapability(world, topPos, world.func_180495_p(topPos), targetStack, player, consumeResources);
        }
        return targetStack;
    }

    @Override
    public void init(PacketHandler packetHandler) {
        super.init(packetHandler);
        TileEntityWorkbench.initConfigActions(DataHandler.instance.getData("actions", ConfigActionImpl[].class));
        GuiHandlerRegistry.instance.registerHandler(1, new GuiHandlerWorkbench());
        PacketHandler.instance.registerPacket(UpdateWorkbenchPacket.class, Side.SERVER);
        PacketHandler.instance.registerPacket(CraftWorkbenchPacket.class, Side.SERVER);
        PacketHandler.instance.registerPacket(WorkbenchActionPacket.class, Side.SERVER);
        PacketHandler.instance.registerPacket(TweakWorkbenchPacket.class, Side.SERVER);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{propVariant});
    }

    public IBlockState func_176203_a(int meta) {
        if (meta < Variant.values().length) {
            return this.func_176223_P().func_177226_a(propVariant, (Comparable)((Object)Variant.values()[meta]));
        }
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(propVariant))).ordinal();
    }

    public boolean func_149686_d(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(propVariant))).equals((Object)Variant.wood);
    }

    public boolean func_176214_u(IBlockState state) {
        return this.func_149686_d(state);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return ((Variant)((Object)state.func_177229_b(propVariant))).equals((Object)Variant.wood) ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(propVariant))).equals((Object)Variant.wood);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ((Variant)((Object)state.func_177229_b(propVariant))).equals((Object)Variant.wood) ? field_185505_j : forgedAABB;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((Variant)((Object)state.func_177229_b(propVariant))).equals((Object)Variant.wood) ? this.field_149786_r : 0;
    }

    public Material func_149688_o(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(propVariant))).getMaterial();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return ((Variant)((Object)state.func_177229_b(propVariant))).getHardness();
    }

    public static enum Variant implements IStringSerializable
    {
        wood(Material.field_151575_d, 2.5f),
        forged(Material.field_151574_g, -1.0f);

        private final Material material;
        private final float hardness;

        private Variant(Material material, float hardness) {
            this.material = material;
            this.hardness = hardness;
        }

        Material getMaterial() {
            return this.material;
        }

        public float getHardness() {
            return this.hardness;
        }

        public String func_176610_l() {
            return this.toString();
        }
    }
}

