/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.salvage;

import net.minecraft.entity.player.EntityPlayer;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.GuiInteractiveCapability;
import se.mickelus.tetra.gui.GuiAttachment;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.gui.GuiTexture;
import se.mickelus.tetra.gui.animation.Applier;
import se.mickelus.tetra.gui.animation.KeyframeAnimation;

public class GuiInteractiveOutline
extends GuiElement {
    private static final String texture = "textures/gui/block-interaction.png";
    private BlockInteraction blockInteraction;
    private GuiTexture topLeft;
    private GuiTexture topRight;
    private GuiTexture bottomLeft;
    private GuiTexture bottomRight;
    private GuiInteractiveCapability capability;

    public GuiInteractiveOutline(BlockInteraction blockInteraction, EntityPlayer player) {
        super((int)blockInteraction.minX * 2, (int)blockInteraction.minY * 2, (int)(blockInteraction.maxX - blockInteraction.minX) * 2, (int)(blockInteraction.maxY - blockInteraction.minY) * 2);
        this.blockInteraction = blockInteraction;
        this.opacity = 0.3f;
        this.topLeft = new GuiTexture(-2, -2, 4, 4, 0, 0, texture);
        this.addChild(this.topLeft);
        new KeyframeAnimation(100, this.topLeft).applyTo(new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX(0.0f, -2.0f), new Applier.TranslateY(0.0f, -2.0f)).withDelay(500).start();
        this.topRight = new GuiTexture(2, -2, 4, 4, 3, 0, texture);
        this.topRight.setAttachment(GuiAttachment.topRight);
        this.addChild(this.topRight);
        new KeyframeAnimation(100, this.topRight).applyTo(new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX(0.0f, 2.0f), new Applier.TranslateY(0.0f, -2.0f)).withDelay(650).start();
        this.bottomLeft = new GuiTexture(-2, 2, 4, 4, 3, 0, texture);
        this.bottomLeft.setAttachment(GuiAttachment.bottomLeft);
        this.addChild(this.bottomLeft);
        new KeyframeAnimation(100, this.bottomLeft).applyTo(new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX(0.0f, -2.0f), new Applier.TranslateY(0.0f, 2.0f)).withDelay(500).start();
        this.bottomRight = new GuiTexture(2, 2, 4, 4, 0, 0, texture);
        this.bottomRight.setAttachment(GuiAttachment.bottomRight);
        this.addChild(this.bottomRight);
        new KeyframeAnimation(100, this.bottomRight).applyTo(new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX(0.0f, 2.0f), new Applier.TranslateY(0.0f, 2.0f)).withDelay(650).onStop(complete -> {
            if (this.capability != null) {
                this.capability.updateFadeTime();
            }
        }).start();
        if (blockInteraction.requiredCapability != null) {
            this.capability = new GuiInteractiveCapability(0, 0, blockInteraction.requiredCapability, blockInteraction.requiredLevel, player);
            this.addChild(this.capability);
            float centerY = (float)this.y + (float)this.height / 2.0f;
            float centerX = (float)this.x + (float)this.width / 2.0f;
            if (Math.abs(centerX - 16.0f) > Math.abs(centerY - 16.0f)) {
                if (centerX < 16.0f) {
                    this.capability.setAttachmentPoint(GuiAttachment.middleLeft);
                    this.capability.setAttachmentAnchor(GuiAttachment.middleRight);
                } else {
                    this.capability.setAttachmentPoint(GuiAttachment.middleRight);
                    this.capability.setAttachmentAnchor(GuiAttachment.middleLeft);
                    this.capability.setX(1);
                }
            } else if (centerY < 16.0f) {
                this.capability.setAttachmentPoint(GuiAttachment.topCenter);
                this.capability.setAttachmentAnchor(GuiAttachment.bottomCenter);
                this.capability.setY(1);
            } else {
                this.capability.setAttachmentPoint(GuiAttachment.bottomCenter);
                this.capability.setAttachmentAnchor(GuiAttachment.topCenter);
                this.capability.setY(-2);
            }
        }
    }

    @Override
    protected void onFocus() {
        super.onFocus();
        if (this.capability != null) {
            this.capability.show();
        }
    }

    @Override
    protected void onBlur() {
        super.onBlur();
        if (this.capability != null) {
            this.capability.hide();
        }
    }

    public BlockInteraction getBlockInteraction() {
        return this.blockInteraction;
    }

    public void transitionOut(Runnable onStop) {
        new KeyframeAnimation(200, this.topLeft).applyTo(new Applier.Opacity(1.0f, 0.0f), new Applier.TranslateX(-5.0f), new Applier.TranslateY(-5.0f)).start();
        new KeyframeAnimation(200, this.topRight).applyTo(new Applier.Opacity(1.0f, 0.0f), new Applier.TranslateX(5.0f), new Applier.TranslateY(-5.0f)).start();
        new KeyframeAnimation(200, this.bottomLeft).applyTo(new Applier.Opacity(1.0f, 0.0f), new Applier.TranslateX(-5.0f), new Applier.TranslateY(5.0f)).start();
        new KeyframeAnimation(200, this.bottomRight).applyTo(new Applier.Opacity(1.0f, 0.0f), new Applier.TranslateX(5.0f), new Applier.TranslateY(5.0f)).onStop(finished -> onStop.run()).start();
    }
}

