/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.salvage;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import se.mickelus.tetra.RotationHelper;
import se.mickelus.tetra.advancements.BlockInteractionCriterion;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.blocks.salvage.IBlockCapabilityInteractive;
import se.mickelus.tetra.blocks.salvage.InteractionOutcome;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.capabilities.CapabilityHelper;
import se.mickelus.tetra.items.ItemModular;

public class BlockInteraction {
    public Capability requiredCapability;
    public int requiredLevel;
    public EnumFacing face;
    public float minX;
    public float minY;
    public float maxX;
    public float maxY;
    public Predicate<IBlockState> predicate;
    public InteractionOutcome outcome;
    public float successChance = 1.0f;

    public <V extends Comparable<V>> BlockInteraction(Capability requiredCapability, int requiredLevel, EnumFacing face, float minX, float maxX, float minY, float maxY, IProperty<V> property, V propertyValue, InteractionOutcome outcome) {
        this.requiredCapability = requiredCapability;
        this.requiredLevel = requiredLevel;
        this.face = face;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.predicate = new PropertyMatcher().where(property, Predicates.equalTo(propertyValue));
        this.outcome = outcome;
    }

    public BlockInteraction(Capability requiredCapability, int requiredLevel, EnumFacing face, float minX, float maxX, float minY, float maxY, Predicate<IBlockState> predicate, InteractionOutcome outcome) {
        this.requiredCapability = requiredCapability;
        this.requiredLevel = requiredLevel;
        this.face = face;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.predicate = predicate;
        this.outcome = outcome;
    }

    public boolean applicableForState(IBlockState blockState) {
        return this.predicate.test(blockState);
    }

    public boolean isWithinBounds(float x, float y) {
        return this.minX <= x && x <= this.maxX && this.minY <= y && y <= this.maxY;
    }

    public boolean isPotentialInteraction(IBlockState blockState, EnumFacing hitFace, Collection<Capability> availableCapabilities) {
        return this.isPotentialInteraction(blockState, EnumFacing.NORTH, hitFace, availableCapabilities);
    }

    public boolean isPotentialInteraction(IBlockState blockState, EnumFacing blockFacing, EnumFacing hitFace, Collection<Capability> availableCapabilities) {
        return this.applicableForState(blockState) && RotationHelper.rotationFromFacing(blockFacing).func_185831_a(this.face).equals((Object)hitFace) && availableCapabilities.contains((Object)this.requiredCapability);
    }

    public void applyOutcome(World world, BlockPos pos, IBlockState blockState, EntityPlayer player, EnumHand hand, EnumFacing hitFace) {
        this.outcome.apply(world, pos, blockState, player, hand, hitFace);
    }

    public static boolean attemptInteraction(World world, IBlockState blockState, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing hitFace, float hitX, float hitY, float hitZ) {
        ItemStack heldStack = player.func_184586_b(hand);
        Collection<Capability> availableCapabilities = CapabilityHelper.getItemCapabilities(heldStack);
        if ((double)player.func_184825_o(0.0f) < 0.8) {
            player.func_184821_cY();
            return false;
        }
        AxisAlignedBB boundingBox = blockState.func_185900_c((IBlockAccess)world, pos);
        float hitU = BlockInteraction.getHitU(hitFace, boundingBox, hitX, hitY, hitZ);
        float hitV = BlockInteraction.getHitV(hitFace, boundingBox, hitX, hitY, hitZ);
        BlockInteraction possibleInteraction = Optional.of(blockState.func_177230_c()).filter(block -> block instanceof IBlockCapabilityInteractive).map(block -> (IBlockCapabilityInteractive)block).map(block -> block.getPotentialInteractions(blockState, hitFace, availableCapabilities)).map(Arrays::stream).orElseGet(Stream::empty).filter(interaction -> interaction.isWithinBounds(hitU * 16.0f, hitV * 16.0f)).filter(interaction -> CapabilityHelper.getItemCapabilityLevel(heldStack, interaction.requiredCapability) >= interaction.requiredLevel).findFirst().orElse(null);
        if (possibleInteraction != null) {
            possibleInteraction.applyOutcome(world, pos, blockState, player, hand, hitFace);
            if (availableCapabilities.contains((Object)possibleInteraction.requiredCapability) && heldStack.func_77984_f()) {
                if (heldStack.func_77973_b() instanceof ItemModular) {
                    ((ItemModular)heldStack.func_77973_b()).applyDamage(2, heldStack, (EntityLivingBase)player);
                } else {
                    heldStack.func_77972_a(2, (EntityLivingBase)player);
                }
            }
            if (player instanceof EntityPlayerMP) {
                IBlockState newState = world.func_180495_p(pos);
                newState = newState.func_185899_b((IBlockAccess)world, pos);
                BlockInteractionCriterion.trigger((EntityPlayerMP)player, newState, possibleInteraction.requiredCapability, possibleInteraction.requiredLevel);
            }
            player.func_184821_cY();
            return true;
        }
        return false;
    }

    public static BlockInteraction getInteractionAtPoint(EntityPlayer player, IBlockState blockState, BlockPos pos, EnumFacing hitFace, float hitX, float hitY, float hitZ) {
        AxisAlignedBB boundingBox = blockState.func_185900_c((IBlockAccess)player.field_70170_p, pos);
        float hitU = BlockInteraction.getHitU(hitFace, boundingBox, hitX, hitY, hitZ);
        float hitV = BlockInteraction.getHitV(hitFace, boundingBox, hitX, hitY, hitZ);
        return Optional.of(blockState.func_177230_c()).filter(block -> block instanceof IBlockCapabilityInteractive).map(block -> (IBlockCapabilityInteractive)block).map(block -> block.getPotentialInteractions(blockState, hitFace, CapabilityHelper.getPlayerCapabilities(player))).map(Arrays::stream).orElseGet(Stream::empty).filter(interaction -> interaction.isWithinBounds(hitU * 16.0f, hitV * 16.0f)).findFirst().orElse(null);
    }

    private static float getHitU(EnumFacing facing, AxisAlignedBB boundingBox, float hitX, float hitY, float hitZ) {
        switch (facing) {
            case DOWN: {
                return (float)boundingBox.field_72336_d - hitX;
            }
            case UP: {
                return (float)boundingBox.field_72336_d - hitX;
            }
            case NORTH: {
                return (float)boundingBox.field_72336_d - hitX;
            }
            case SOUTH: {
                return hitX - (float)boundingBox.field_72340_a;
            }
            case WEST: {
                return hitZ - (float)boundingBox.field_72339_c;
            }
            case EAST: {
                return (float)boundingBox.field_72334_f - hitZ;
            }
        }
        return 0.0f;
    }

    private static float getHitV(EnumFacing facing, AxisAlignedBB boundingBox, float hitX, float hitY, float hitZ) {
        switch (facing) {
            case DOWN: {
                return (float)boundingBox.field_72334_f - hitZ;
            }
            case UP: {
                return (float)boundingBox.field_72334_f - hitZ;
            }
            case NORTH: {
                return (float)boundingBox.field_72337_e - hitY;
            }
            case SOUTH: {
                return (float)boundingBox.field_72337_e - hitY;
            }
            case WEST: {
                return (float)boundingBox.field_72337_e - hitY;
            }
            case EAST: {
                return (float)boundingBox.field_72337_e - hitY;
            }
        }
        return 0.0f;
    }
}

