/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.hammer;

import java.util.Collections;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.WorldServer;
import org.apache.commons.lang3.EnumUtils;
import se.mickelus.tetra.blocks.hammer.BlockHammerBase;
import se.mickelus.tetra.blocks.hammer.EnumHammerConfig;
import se.mickelus.tetra.blocks.hammer.EnumHammerEffect;
import se.mickelus.tetra.blocks.hammer.EnumHammerPlate;
import se.mickelus.tetra.items.cell.ItemCellMagmatic;

public class TileEntityHammerBase
extends TileEntity {
    private static final String slotsKey = "slots";
    private static final String indexKey = "slot";
    private ItemStack[] slots;
    private boolean hasPlateWest = true;
    private boolean hasPlateEast = true;
    private EnumHammerConfig configEast = EnumHammerConfig.A;
    private EnumHammerConfig configWest = EnumHammerConfig.A;

    public TileEntityHammerBase() {
        this.slots = new ItemStack[2];
    }

    public boolean hasEffect(EnumHammerEffect effect) {
        if (effect.requiresBoth) {
            return effect.equals((Object)EnumHammerEffect.fromConfig(this.configEast, this.func_145831_w().func_72905_C())) && effect.equals((Object)EnumHammerEffect.fromConfig(this.configWest, this.func_145831_w().func_72905_C()));
        }
        return effect.equals((Object)EnumHammerEffect.fromConfig(this.configEast, this.func_145831_w().func_72905_C())) || effect.equals((Object)EnumHammerEffect.fromConfig(this.configWest, this.func_145831_w().func_72905_C()));
    }

    public int getHammerLevel() {
        return this.hasEffect(EnumHammerEffect.OVERCHARGED) ? 5 : 4;
    }

    public boolean isFueled() {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.getCellFuel(i) > 0) continue;
            return false;
        }
        return true;
    }

    public void consumeFuel() {
        int fuelUsage = this.fuelUsage();
        for (int i = 0; i < this.slots.length; ++i) {
            this.consumeFuel(i, fuelUsage);
        }
        this.applyConsumeEffect();
    }

    public void consumeFuel(int index, int amount) {
        if (index >= 0 && index < this.slots.length && this.slots[index] != null && this.slots[index].func_77973_b() instanceof ItemCellMagmatic) {
            ItemCellMagmatic item = (ItemCellMagmatic)this.slots[index].func_77973_b();
            item.drainCharge(this.slots[index], amount);
        }
    }

    private void applyConsumeEffect() {
        EnumFacing facing = (EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockHammerBase.propFacing);
        Vec3d pos = new Vec3d((Vec3i)this.func_174877_v());
        pos = pos.func_72441_c(0.5, 0.5, 0.5);
        if (!this.field_145850_b.field_72995_K && this.hasEffect(EnumHammerEffect.LEAKY)) {
            int countCell0 = this.field_145850_b.field_73012_v.nextInt(Math.min(16, this.getCellFuel(0)));
            int countCell1 = this.field_145850_b.field_73012_v.nextInt(Math.min(16, this.getCellFuel(1)));
            this.consumeFuel(0, countCell0);
            this.consumeFuel(1, countCell1);
            if (countCell0 > 0 || countCell1 > 0) {
                Vec3d posCell0 = pos.func_178787_e(new Vec3d(facing.func_176730_m()).func_186678_a(0.55));
                this.spawnParticle(EnumParticleTypes.LAVA, posCell0, countCell0 * 2, 0.06f);
                this.spawnParticle(EnumParticleTypes.SMOKE_LARGE, posCell0, 2, 0.0f);
                Vec3d posCell1 = pos.func_178787_e(new Vec3d(facing.func_176734_d().func_176730_m()).func_186678_a(0.55));
                this.spawnParticle(EnumParticleTypes.LAVA, posCell1, countCell1 * 2, 0.06f);
                this.spawnParticle(EnumParticleTypes.SMOKE_LARGE, posCell1, 2, 0.0f);
                LinkedList<BlockPos> flammableBlocks = new LinkedList<BlockPos>();
                for (int x = -3; x < 3; ++x) {
                    for (int y = -3; y < 2; ++y) {
                        for (int z = -3; z < 3; ++z) {
                            BlockPos firePos = this.func_174877_v().func_177982_a(x, y, z);
                            if (!this.field_145850_b.func_175623_d(firePos)) continue;
                            flammableBlocks.add(firePos);
                        }
                    }
                }
                Collections.shuffle(flammableBlocks);
                flammableBlocks.stream().limit(countCell0 + countCell1).forEach(blockPos -> this.field_145850_b.func_180501_a(blockPos, Blocks.field_150480_ab.func_176223_P(), 11));
            }
        }
    }

    private int fuelUsage() {
        int usage = 5;
        if (!this.hasPlateEast) {
            usage += 2;
        }
        if (!this.hasPlateWest) {
            usage += 2;
        }
        if (this.hasEffect(EnumHammerEffect.OVERCHARGED)) {
            usage += 4;
        }
        if (this.hasEffect(EnumHammerEffect.EFFICIENT)) {
            usage -= 3;
        }
        return Math.max(usage, 1);
    }

    public boolean hasCellInSlot(int index) {
        return index >= 0 && index < this.slots.length && this.slots[index] != null;
    }

    public int getCellFuel(int index) {
        if (index >= 0 && index < this.slots.length && this.slots[index] != null && this.slots[index].func_77973_b() instanceof ItemCellMagmatic) {
            ItemCellMagmatic item = (ItemCellMagmatic)this.slots[index].func_77973_b();
            return item.getCharge(this.slots[index]);
        }
        return -1;
    }

    public ItemStack removeCellFromSlot(int index) {
        if (index >= 0 && index < this.slots.length && this.slots[index] != null) {
            ItemStack itemStack = this.slots[index];
            this.slots[index] = null;
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean putCellInSlot(ItemStack itemStack, int index) {
        if (itemStack.func_77973_b() instanceof ItemCellMagmatic && index >= 0 && index < this.slots.length && this.slots[index] == null) {
            this.slots[index] = itemStack;
            return true;
        }
        return false;
    }

    public void removePlate(EnumHammerPlate plate) {
        switch (plate) {
            case EAST: {
                this.hasPlateEast = false;
                break;
            }
            case WEST: {
                this.hasPlateWest = false;
            }
        }
        this.func_70296_d();
    }

    public void attachPlate(EnumHammerPlate plate) {
        switch (plate) {
            case EAST: {
                this.hasPlateEast = true;
                break;
            }
            case WEST: {
                this.hasPlateWest = true;
            }
        }
        this.func_70296_d();
    }

    public boolean hasPlate(EnumHammerPlate plate) {
        switch (plate) {
            case EAST: {
                return this.hasPlateEast;
            }
            case WEST: {
                return this.hasPlateWest;
            }
        }
        return false;
    }

    public void reconfigure(EnumFacing side) {
        if (EnumFacing.EAST.equals((Object)side)) {
            this.configEast = EnumHammerConfig.getNextConfiguration(this.configEast);
            this.applyReconfigurationEffect(EnumHammerEffect.fromConfig(this.configEast, this.field_145850_b.func_72905_C()));
        } else if (EnumFacing.WEST.equals((Object)side)) {
            this.configWest = EnumHammerConfig.getNextConfiguration(this.configWest);
            this.applyReconfigurationEffect(EnumHammerEffect.fromConfig(this.configWest, this.field_145850_b.func_72905_C()));
        }
        this.func_70296_d();
    }

    private void applyReconfigurationEffect(EnumHammerEffect effect) {
        Vec3d rotPos;
        EnumFacing facing = (EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockHammerBase.propFacing);
        Vec3d pos = new Vec3d((Vec3i)this.func_174877_v());
        pos = pos.func_72441_c(0.5, 0.5, 0.5);
        if (EnumHammerEffect.OVERCHARGED.equals((Object)effect)) {
            if (!this.hasCellInSlot(0)) {
                rotPos = pos.func_178787_e(new Vec3d(facing.func_176730_m()).func_186678_a(0.55));
                this.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, rotPos, 15, 0.02f);
            }
            if (!this.hasCellInSlot(1)) {
                rotPos = pos.func_178787_e(new Vec3d(facing.func_176734_d().func_176730_m()).func_186678_a(0.55));
                this.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, rotPos, 15, 0.02f);
            }
        }
        if (EnumHammerEffect.LEAKY.equals((Object)effect)) {
            if (this.getCellFuel(0) > 0) {
                rotPos = pos.func_178787_e(new Vec3d(facing.func_176730_m()).func_186678_a(0.55));
                this.spawnParticle(EnumParticleTypes.LAVA, rotPos, 3, 0.06f);
                this.spawnParticle(EnumParticleTypes.SMOKE_LARGE, rotPos, 3, 0.0f);
            }
            if (this.getCellFuel(1) > 0) {
                rotPos = pos.func_178787_e(new Vec3d(facing.func_176734_d().func_176730_m()).func_186678_a(0.55));
                this.spawnParticle(EnumParticleTypes.LAVA, rotPos, 3, 0.06f);
                this.spawnParticle(EnumParticleTypes.SMOKE_LARGE, rotPos, 3, 0.0f);
            }
        }
    }

    public EnumHammerConfig getConfiguration(EnumFacing side) {
        if (EnumFacing.EAST.equals((Object)side)) {
            return this.configEast;
        }
        if (EnumFacing.WEST.equals((Object)side)) {
            return this.configWest;
        }
        return EnumHammerConfig.A;
    }

    private void spawnParticle(EnumParticleTypes particle, Vec3d pos, int count, float speed) {
        if (this.field_145850_b instanceof WorldServer) {
            ((WorldServer)this.field_145850_b).func_175739_a(particle, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, count, 0.0, 0.0, 0.0, (double)speed, new int[0]);
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound compound) {
        String enumName;
        super.func_145839_a(compound);
        if (compound.func_74764_b(slotsKey)) {
            NBTTagList tagList = compound.func_150295_c(slotsKey, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
                int slot = nbttagcompound.func_74771_c(indexKey) & 0xFF;
                if (slot >= this.slots.length) continue;
                this.slots[slot] = new ItemStack(nbttagcompound);
            }
        }
        this.hasPlateEast = compound.func_74767_n(EnumHammerPlate.EAST.key);
        this.hasPlateWest = compound.func_74767_n(EnumHammerPlate.WEST.key);
        if (compound.func_74764_b(EnumHammerConfig.propE.func_177701_a()) && EnumUtils.isValidEnum(EnumHammerConfig.class, (String)(enumName = compound.func_74779_i(EnumHammerConfig.propE.func_177701_a())))) {
            this.configEast = EnumHammerConfig.valueOf(enumName);
        }
        if (compound.func_74764_b(EnumHammerConfig.propW.func_177701_a()) && EnumUtils.isValidEnum(EnumHammerConfig.class, (String)(enumName = compound.func_74779_i(EnumHammerConfig.propW.func_177701_a())))) {
            this.configWest = EnumHammerConfig.valueOf(enumName);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        TileEntityHammerBase.writeCells(compound, this.slots);
        TileEntityHammerBase.writePlate(compound, EnumHammerPlate.EAST, this.hasPlateEast);
        TileEntityHammerBase.writePlate(compound, EnumHammerPlate.WEST, this.hasPlateWest);
        TileEntityHammerBase.writeConfig(compound, this.configEast, this.configWest);
        return compound;
    }

    public static void writeCells(NBTTagCompound compound, ItemStack ... cells) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < cells.length; ++i) {
            if (cells[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a(indexKey, (byte)i);
            cells[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a(slotsKey, (NBTBase)nbttaglist);
    }

    public static void writePlate(NBTTagCompound compound, EnumHammerPlate plate, boolean hasPlate) {
        compound.func_74757_a(plate.key, hasPlate);
    }

    public static void writeConfig(NBTTagCompound compound, EnumHammerConfig configEast, EnumHammerConfig configWest) {
        compound.func_74778_a(EnumHammerConfig.propE.func_177701_a(), configEast.toString());
        compound.func_74778_a(EnumHammerConfig.propW.func_177701_a(), configWest.toString());
    }
}

