/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.hammer;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.hammer.BlockHammerBase;
import se.mickelus.tetra.blocks.hammer.TileEntityHammerHead;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.items.TetraCreativeTabs;

public class BlockHammerHead
extends TetraBlock
implements ITileEntityProvider {
    static final String unlocalizedName = "hammer_head";
    public static final AxisAlignedBB boundingBox = new AxisAlignedBB(0.125, 0.8125, 0.125, 0.875, 1.0, 0.875);
    public static BlockHammerHead instance;

    public BlockHammerHead() {
        super(Material.field_151573_f);
        this.setRegistryName(unlocalizedName);
        this.func_149663_c(unlocalizedName);
        GameRegistry.registerTileEntity(TileEntityHammerHead.class, (String)"tetra:tile_hammer_head");
        this.func_149647_a(TetraCreativeTabs.getInstance());
        this.func_149722_s();
        this.hasItem = true;
        instance = this;
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.clear();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"forged_description", (Object[])new Object[0]));
    }

    @Override
    public Collection<Capability> getCapabilities(World world, BlockPos pos, IBlockState blockState) {
        BlockHammerBase baseBlock;
        BlockPos basePos = pos.func_177972_a(EnumFacing.UP);
        if (world.func_180495_p(basePos).func_177230_c() instanceof BlockHammerBase && (baseBlock = (BlockHammerBase)world.func_180495_p(basePos).func_177230_c()).isFueled(world, basePos)) {
            return Collections.singletonList(Capability.hammer);
        }
        return super.getCapabilities(world, pos, blockState);
    }

    @Override
    public int getCapabilityLevel(World world, BlockPos pos, IBlockState blockState, Capability capability) {
        BlockHammerBase baseBlock;
        BlockPos basePos = pos.func_177972_a(EnumFacing.UP);
        if (Capability.hammer.equals((Object)capability) && world.func_180495_p(basePos).func_177230_c() instanceof BlockHammerBase && (baseBlock = (BlockHammerBase)world.func_180495_p(basePos).func_177230_c()).isFueled(world, basePos)) {
            return baseBlock.getHammerLevel(world, basePos);
        }
        return super.getCapabilityLevel(world, pos, blockState, capability);
    }

    @Override
    public ItemStack onCraftConsumeCapability(World world, BlockPos pos, IBlockState blockState, ItemStack targetStack, EntityPlayer player, boolean consumeResources) {
        BlockPos basePos = pos.func_177972_a(EnumFacing.UP);
        if (consumeResources && world.func_180495_p(basePos).func_177230_c() instanceof BlockHammerBase) {
            BlockHammerBase baseBlock = (BlockHammerBase)world.func_180495_p(basePos).func_177230_c();
            baseBlock.consumeFuel(world, basePos);
            baseBlock.applyEffects(world, basePos, targetStack, player);
            ((TileEntityHammerHead)world.func_175625_s(pos)).activate();
            world.func_184133_a(player, pos, SoundEvents.field_187689_f, SoundCategory.PLAYERS, 3.0f, (float)(0.5 + Math.random() * 0.1));
        }
        return targetStack;
    }

    @Override
    public ItemStack onActionConsumeCapability(World world, BlockPos pos, IBlockState blockState, ItemStack targetStack, EntityPlayer player, boolean consumeResources) {
        BlockPos basePos = pos.func_177972_a(EnumFacing.UP);
        if (consumeResources && world.func_180495_p(basePos).func_177230_c() instanceof BlockHammerBase) {
            BlockHammerBase baseBlock = (BlockHammerBase)world.func_180495_p(basePos).func_177230_c();
            baseBlock.consumeFuel(world, basePos);
            ((TileEntityHammerHead)world.func_175625_s(pos)).activate();
            world.func_184133_a(player, pos, SoundEvents.field_187689_f, SoundCategory.PLAYERS, 3.0f, (float)(0.5 + Math.random() * 0.1));
        }
        return targetStack;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return boundingBox;
    }

    public ExtendedBlockState createBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{Properties.StaticProperty}, new IUnlistedProperty[]{Properties.AnimationProperty});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityHammerHead();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)Properties.StaticProperty, (Comparable)Boolean.valueOf(false));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

