/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.transfer;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import org.apache.commons.lang3.EnumUtils;
import se.mickelus.tetra.blocks.IHeatTransfer;
import se.mickelus.tetra.blocks.forged.transfer.BlockTransferUnit;
import se.mickelus.tetra.blocks.forged.transfer.EnumTransferConfig;
import se.mickelus.tetra.blocks.forged.transfer.EnumTransferEffect;
import se.mickelus.tetra.items.cell.ItemCellMagmatic;
import se.mickelus.tetra.util.CastOptional;
import se.mickelus.tetra.util.TileEntityOptional;

public class TileEntityTransferUnit
extends TileEntity
implements ITickable,
IHeatTransfer {
    private boolean hasPlate = true;
    private EnumTransferConfig config = EnumTransferConfig.A;
    private ItemStack cell = ItemStack.field_190927_a;
    private boolean isSending = false;
    private boolean isReceiving = false;
    private static final int baseAmount = 8;
    private float efficiency = 1.0f;

    public void removePlate() {
        this.hasPlate = false;
        this.func_70296_d();
    }

    public void attachPlate() {
        this.hasPlate = true;
        this.func_70296_d();
    }

    public boolean hasPlate() {
        return this.hasPlate;
    }

    public EnumTransferConfig getConfiguration() {
        return this.config;
    }

    public EnumTransferEffect getEffect() {
        return EnumTransferEffect.fromConfig(this.config, 0L);
    }

    public EnumTransferEffect getEffectPowered() {
        EnumTransferEffect effect = EnumTransferEffect.fromConfig(this.config, 0L);
        if (effect.equals((Object)EnumTransferEffect.REDSTONE)) {
            EnumFacing facing = this.getFacing();
            if (this.field_145850_b.func_175709_b(this.field_174879_c.func_177972_a(facing.func_176746_e()), facing.func_176746_e())) {
                return EnumTransferEffect.SEND;
            }
            if (this.field_145850_b.func_175709_b(this.field_174879_c.func_177972_a(facing.func_176735_f()), facing.func_176735_f())) {
                return EnumTransferEffect.RECEIVE;
            }
        }
        return effect;
    }

    public void reconfigure() {
        this.config = EnumTransferConfig.getNextConfiguration(this.config);
        this.updateTransferState();
        this.notifyBlockUpdate();
    }

    public boolean hasCell() {
        return !this.cell.func_190926_b();
    }

    public ItemStack removeCell() {
        ItemStack removedCell = this.cell;
        this.cell = ItemStack.field_190927_a;
        this.updateTransferState();
        return removedCell;
    }

    public boolean putCell(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemCellMagmatic) {
            this.cell = itemStack;
            this.updateTransferState();
            return true;
        }
        return false;
    }

    private Optional<IHeatTransfer> getConnectedUnit() {
        return TileEntityOptional.from((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(this.getFacing()), IHeatTransfer.class);
    }

    @Override
    public int getCharge() {
        return CastOptional.cast(this.cell.func_77973_b(), ItemCellMagmatic.class).map(item -> item.getCharge(this.cell)).orElse(0);
    }

    @Override
    public float getEfficiency() {
        return this.hasPlate() ? 1.0f : 0.9f;
    }

    @Override
    public boolean canRecieve() {
        return this.getEffectPowered().equals((Object)EnumTransferEffect.RECEIVE) && this.hasCell() && this.getCharge() < 128;
    }

    @Override
    public boolean canSend() {
        return this.getEffectPowered().equals((Object)EnumTransferEffect.SEND) && this.hasCell() && this.getCharge() > 0;
    }

    @Override
    public void setReceiving(boolean receiving) {
        this.isReceiving = receiving;
        if (this.isReceiving) {
            this.setSending(false);
        }
        this.notifyBlockUpdate();
    }

    @Override
    public boolean isReceiving() {
        return this.isReceiving;
    }

    @Override
    public void setSending(boolean sending) {
        this.isSending = sending;
        if (this.isSending) {
            this.isReceiving = false;
        }
        this.notifyBlockUpdate();
    }

    @Override
    public boolean isSending() {
        return this.isSending;
    }

    @Override
    public int getReceiveLimit() {
        return 8;
    }

    @Override
    public int getSendLimit() {
        return 8;
    }

    @Override
    public int drain(int amount) {
        return CastOptional.cast(this.cell.func_77973_b(), ItemCellMagmatic.class).map(item -> {
            int drained = item.drainCharge(this.cell, amount);
            if (item.getCharge(this.cell) == 0) {
                this.runDrainedEffects();
            }
            return drained;
        }).orElse(0);
    }

    @Override
    public int fill(int amount) {
        return CastOptional.cast(this.cell.func_77973_b(), ItemCellMagmatic.class).map(item -> {
            if (item.getCharge(this.cell) == 0) {
                this.notifyBlockUpdate();
            }
            int overfill = item.recharge(this.cell, amount);
            if (item.getCharge(this.cell) == 128) {
                this.runFilledEffects();
            }
            return overfill;
        }).orElse(0);
    }

    public void func_73660_a() {
        if (this.isSending && this.field_145850_b.func_82737_E() % 5L == 0L) {
            this.transfer();
        }
    }

    public void transfer() {
        if (this.canSend()) {
            this.getConnectedUnit().ifPresent(connected -> {
                if (connected.canRecieve()) {
                    int amount = this.drain(8);
                    int overfill = connected.fill((int)((float)amount * this.efficiency));
                    if (overfill > 0) {
                        this.fill(overfill);
                    }
                    this.func_70296_d();
                } else {
                    this.setSending(false);
                    connected.setReceiving(false);
                }
            });
        } else {
            this.getConnectedUnit().ifPresent(connected -> connected.setReceiving(false));
            this.setSending(false);
        }
    }

    private void runDrainedEffects() {
        if (this.field_145850_b instanceof WorldServer) {
            ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.7, (double)this.field_174879_c.func_177952_p() + 0.5, 10, 0.0, 0.0, 0.0, (double)0.02f, new int[0]);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.2f, 1.0f);
        }
    }

    private void runFilledEffects() {
        if (this.field_145850_b instanceof WorldServer) {
            ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.FLAME, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.7, (double)this.field_174879_c.func_177952_p() + 0.5, 5, 0.0, 0.0, 0.0, (double)0.02f, new int[0]);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.2f, 1.0f);
        }
    }

    @Override
    public void updateTransferState() {
        switch (this.getEffectPowered()) {
            case SEND: {
                this.getConnectedUnit().ifPresent(connected -> {
                    boolean canTransfer;
                    this.isSending = canTransfer = this.canSend() && connected.canRecieve();
                    this.isReceiving = false;
                    connected.setReceiving(canTransfer);
                    this.efficiency = this.getEfficiency() * connected.getEfficiency();
                });
                break;
            }
            case RECEIVE: {
                this.getConnectedUnit().ifPresent(connected -> {
                    if (this.isSending()) {
                        this.setSending(false);
                    }
                    if (connected.canSend()) {
                        connected.updateTransferState();
                    }
                });
                break;
            }
            case REDSTONE: {
                this.getConnectedUnit().ifPresent(connected -> {
                    connected.setSending(false);
                    connected.setReceiving(false);
                    this.setSending(false);
                    this.setReceiving(false);
                });
            }
        }
        this.func_70296_d();
    }

    public void notifyBlockUpdate() {
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public EnumFacing getFacing() {
        return (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockTransferUnit.propFacing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        String enumName;
        super.func_145839_a(compound);
        this.cell = compound.func_74764_b("cell") ? new ItemStack(compound.func_74775_l("cell")) : ItemStack.field_190927_a;
        this.config = EnumTransferConfig.A;
        if (compound.func_74764_b(EnumTransferConfig.prop.func_177701_a()) && EnumUtils.isValidEnum(EnumTransferConfig.class, (String)(enumName = compound.func_74779_i(EnumTransferConfig.prop.func_177701_a())))) {
            this.config = EnumTransferConfig.valueOf(enumName);
        }
        this.hasPlate = compound.func_74767_n("plate");
    }

    public static final void writeCell(NBTTagCompound compound, ItemStack cell) {
        if (!cell.func_190926_b()) {
            NBTTagCompound cellNBT = new NBTTagCompound();
            cell.func_77955_b(cellNBT);
            compound.func_74782_a("cell", (NBTBase)cellNBT);
        }
    }

    public static void writePlate(NBTTagCompound compound, boolean hasPlate) {
        compound.func_74757_a("plate", hasPlate);
    }

    public static void writeConfig(NBTTagCompound compound, EnumTransferConfig config) {
        compound.func_74778_a(EnumTransferConfig.prop.func_177701_a(), config.toString());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        TileEntityTransferUnit.writeCell(compound, this.cell);
        TileEntityTransferUnit.writeConfig(compound, this.config);
        TileEntityTransferUnit.writePlate(compound, this.hasPlate);
        return compound;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.updateTransferState();
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }
}

