/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.transfer;

import com.google.common.base.Predicates;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.mickelus.tetra.advancements.BlockUseCriterion;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.forged.transfer.EnumTransferConfig;
import se.mickelus.tetra.blocks.forged.transfer.TileEntityTransferUnit;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IBlockCapabilityInteractive;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.items.TetraCreativeTabs;
import se.mickelus.tetra.items.cell.ItemCellMagmatic;
import se.mickelus.tetra.items.forged.ItemVentPlate;
import se.mickelus.tetra.util.TileEntityOptional;

public class BlockTransferUnit
extends TetraBlock
implements ITileEntityProvider,
IBlockCapabilityInteractive {
    public static final PropertyDirection propFacing = BlockHorizontal.field_185512_D;
    public static final PropertyBool propPlate = PropertyBool.func_177716_a((String)"plate");
    public static final PropertyInteger propCell = PropertyInteger.func_177719_a((String)"cell", (int)0, (int)2);
    public static final PropertyInteger propTransfer = PropertyInteger.func_177719_a((String)"transfer", (int)0, (int)2);
    private static final ResourceLocation plateLootTable = new ResourceLocation("tetra", "forged/plate_break");
    public static final BlockInteraction[] interactions = new BlockInteraction[]{new BlockInteraction(Capability.pry, 1, EnumFacing.SOUTH, 5.0f, 7.0f, 2.0f, 5.0f, new PropertyMatcher().where(propPlate, Predicates.equalTo((Object)true)), BlockTransferUnit::removePlate), new BlockInteraction(Capability.hammer, 1, EnumFacing.SOUTH, 11.0f, 13.0f, 2.0f, 5.0f, new PropertyMatcher().where(propPlate, Predicates.equalTo((Object)false)), BlockTransferUnit::reconfigure)};
    private static final AxisAlignedBB aabbEast = new AxisAlignedBB(0.1875, 0.0, 0.0625, 1.0, 0.75, 0.9375);
    private static final AxisAlignedBB aabbNorth = new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 0.75, 0.8125);
    private static final AxisAlignedBB aabbWest = new AxisAlignedBB(0.0, 0.0, 0.0625, 0.8125, 0.75, 0.9375);
    private static final AxisAlignedBB aabbSouth = new AxisAlignedBB(0.0625, 0.0, 0.1875, 0.9375, 0.75, 1.0);
    public static final String unlocalizedName = "transfer_unit";
    @GameRegistry.ObjectHolder(value="tetra:transfer_unit")
    public static BlockTransferUnit instance;

    public BlockTransferUnit() {
        super(Material.field_151573_f);
        this.setRegistryName(unlocalizedName);
        this.func_149663_c(unlocalizedName);
        GameRegistry.registerTileEntity(TileEntityTransferUnit.class, (ResourceLocation)new ResourceLocation("tetra", unlocalizedName));
        this.func_149647_a(TetraCreativeTabs.getInstance());
        this.func_149722_s();
        this.hasItem = true;
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)propFacing, (Comparable)EnumFacing.EAST));
    }

    public static boolean removePlate(World world, BlockPos pos, IBlockState blockState, EntityPlayer player, EnumHand hand, EnumFacing hitFace) {
        TileEntityOptional.from((IBlockAccess)world, pos, TileEntityTransferUnit.class).ifPresent(te -> {
            te.removePlate();
            if (!world.field_72995_K) {
                WorldServer worldServer = (WorldServer)world;
                LootTable table = worldServer.func_184146_ak().func_186521_a(plateLootTable);
                LootContext.Builder builder = new LootContext.Builder(worldServer);
                builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
                table.func_186462_a(player.func_70681_au(), builder.func_186471_a()).forEach(itemStack -> BlockTransferUnit.func_180635_a((World)worldServer, (BlockPos)pos, (ItemStack)itemStack));
            }
            world.func_184133_a(player, pos, SoundEvents.field_187769_eM, SoundCategory.PLAYERS, 1.0f, 0.5f);
            world.func_184138_a(pos, blockState, blockState, 3);
        });
        return true;
    }

    public static boolean reconfigure(World world, BlockPos pos, IBlockState blockState, EntityPlayer player, EnumHand hand, EnumFacing hitFace) {
        TileEntityOptional.from((IBlockAccess)world, pos, TileEntityTransferUnit.class).ifPresent(te -> {
            te.reconfigure();
            world.func_184133_a(player, pos, SoundEvents.field_187686_e, SoundCategory.PLAYERS, 1.0f, 1.0f);
            world.func_184138_a(pos, blockState, blockState, 3);
        });
        return true;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.clear();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"forged_description", (Object[])new Object[0]));
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(IBlockState state, EnumFacing face, Collection<Capability> capabilities) {
        return (BlockInteraction[])Arrays.stream(new BlockInteraction[]{new BlockInteraction(Capability.pry, 1, EnumFacing.SOUTH, 3.0f, 11.0f, 4.0f, 6.0f, new PropertyMatcher().where(propPlate, Predicates.equalTo((Object)true)), BlockTransferUnit::removePlate), new BlockInteraction(Capability.hammer, 1, EnumFacing.SOUTH, 4.0f, 10.0f, 5.0f, 9.0f, new PropertyMatcher().where(propPlate, Predicates.equalTo((Object)false)), BlockTransferUnit::reconfigure)}).filter(interaction -> interaction.isPotentialInteraction(state, (EnumFacing)state.func_177229_b((IProperty)propFacing), face, capabilities)).toArray(BlockInteraction[]::new);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumFacing blockFacing = (EnumFacing)state.func_177229_b((IProperty)propFacing);
        TileEntityTransferUnit te = TileEntityOptional.from((IBlockAccess)world, pos, TileEntityTransferUnit.class).orElse(null);
        ItemStack heldStack = player.func_184586_b(hand);
        if (te == null) {
            return false;
        }
        if (facing.equals((Object)EnumFacing.UP)) {
            if (te.hasCell()) {
                ItemStack cell = te.removeCell();
                if (player.field_71071_by.func_70441_a(cell)) {
                    player.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
                } else {
                    BlockTransferUnit.func_180635_a((World)world, (BlockPos)pos.func_177984_a(), (ItemStack)cell);
                }
                world.func_184133_a(player, pos, SoundEvents.field_187614_cJ, SoundCategory.PLAYERS, 0.5f, 0.6f);
                world.func_184138_a(pos, state, state, 3);
                if (!player.field_70170_p.field_72995_K) {
                    BlockUseCriterion.trigger((EntityPlayerMP)player, this.func_176221_a(state, (IBlockAccess)world, pos), ItemStack.field_190927_a);
                }
                return true;
            }
            if (heldStack.func_77973_b() instanceof ItemCellMagmatic) {
                te.putCell(heldStack);
                player.func_184611_a(hand, ItemStack.field_190927_a);
                world.func_184133_a(player, pos, SoundEvents.field_187614_cJ, SoundCategory.PLAYERS, 0.5f, 0.5f);
                world.func_184138_a(pos, state, state, 3);
                if (!player.field_70170_p.field_72995_K) {
                    BlockUseCriterion.trigger((EntityPlayerMP)player, this.func_176221_a(state, (IBlockAccess)world, pos), ItemStack.field_190927_a);
                }
                return true;
            }
        } else if (blockFacing.equals((Object)facing.func_176734_d()) && heldStack.func_77973_b() instanceof ItemVentPlate && !te.hasPlate()) {
            te.attachPlate();
            world.func_184133_a(player, pos, SoundEvents.field_187772_dn, SoundCategory.PLAYERS, 0.5f, 1.0f);
            world.func_184138_a(pos, state, state, 3);
            heldStack.func_190918_g(1);
            if (!player.field_70170_p.field_72995_K) {
                BlockUseCriterion.trigger((EntityPlayerMP)player, this.func_176221_a(state, (IBlockAccess)world, pos), ItemStack.field_190927_a);
            }
            return true;
        }
        return BlockInteraction.attemptInteraction(world, this.func_176221_a(world.func_180495_p(pos), (IBlockAccess)world, pos), pos, player, hand, facing, hitX, hitY, hitZ);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block fromBlock, BlockPos fromPos) {
        if (!pos.func_177972_a((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)propFacing)).equals((Object)fromPos)) {
            TileEntityOptional.from((IBlockAccess)world, pos, TileEntityTransferUnit.class).ifPresent(TileEntityTransferUnit::updateTransferState);
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)this.func_176221_a(state, source, pos).func_177229_b((IProperty)propFacing);
        switch (facing) {
            case NORTH: {
                return aabbNorth;
            }
            case EAST: {
                return aabbEast;
            }
            case SOUTH: {
                return aabbSouth;
            }
            case WEST: {
                return aabbWest;
            }
        }
        return null;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{propFacing, EnumTransferConfig.prop, propPlate, propCell, propTransfer});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return TileEntityOptional.from(world, pos, TileEntityTransferUnit.class).map(te -> state.func_177226_a((IProperty)propPlate, (Comparable)Boolean.valueOf(te.hasPlate())).func_177226_a((IProperty)propCell, (Comparable)Integer.valueOf(te.hasCell() ? (te.getCharge() > 0 ? 2 : 1) : 0)).func_177226_a((IProperty)propTransfer, (Comparable)Integer.valueOf(te.isReceiving() ? 2 : (te.isSending() ? 1 : 0))).func_177226_a(EnumTransferConfig.prop, (Comparable)((Object)te.getConfiguration()))).orElse(state);
    }

    public IBlockState func_176203_a(int meta) {
        return super.func_176223_P().func_177226_a((IProperty)propFacing, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)propFacing)).func_176736_b();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityTransferUnit();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState iblockstate = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        return iblockstate.func_177226_a((IProperty)propFacing, (Comparable)placer.func_174811_aO());
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)propFacing, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)propFacing)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)propFacing)));
    }
}

