/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.container;

import java.io.IOException;
import java.util.stream.IntStream;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.mickelus.tetra.blocks.forged.container.ContainerForgedContainer;
import se.mickelus.tetra.blocks.forged.container.TileEntityForgedContainer;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.gui.GuiRect;
import se.mickelus.tetra.gui.GuiTexture;
import se.mickelus.tetra.gui.animation.AnimationChain;
import se.mickelus.tetra.gui.animation.Applier;
import se.mickelus.tetra.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.impl.GuiTabVerticalGroup;

@SideOnly(value=Side.CLIENT)
public class GuiForgedContainer
extends GuiContainer {
    private static final String containerTexture = "textures/gui/forged-container.png";
    private static final String playerInventoryTexture = "textures/gui/player-inventory.png";
    private final TileEntityForgedContainer tileEntity;
    private final ContainerForgedContainer container;
    private final GuiElement gui;
    private final AnimationChain slotTransition;
    private final GuiTabVerticalGroup compartmentButtons;

    public GuiForgedContainer(ContainerForgedContainer container, TileEntityForgedContainer tileEntity) {
        super((Container)container);
        this.field_146291_p = false;
        this.field_146999_f = 179;
        this.field_147000_g = 176;
        this.tileEntity = tileEntity;
        this.container = container;
        this.gui = new GuiElement(0, 0, this.field_146999_f, this.field_147000_g);
        this.gui.addChild(new GuiTexture(0, -13, 179, 128, containerTexture));
        this.gui.addChild(new GuiTexture(0, 103, 179, 106, playerInventoryTexture));
        this.compartmentButtons = new GuiTabVerticalGroup(10, 26, this::changeCompartment, (String[])IntStream.range(1, TileEntityForgedContainer.compartmentCount + 1).mapToObj(i -> I18n.func_135052_a((String)"forged_container.compartment", (Object[])new Object[]{i})).toArray(String[]::new));
        this.gui.addChild(this.compartmentButtons);
        GuiRect slotTransitionElement = new GuiRect(12, 0, 152, 101, 0);
        slotTransitionElement.setOpacity(0.0f);
        this.gui.addChild(slotTransitionElement);
        this.slotTransition = new AnimationChain(new KeyframeAnimation(30, slotTransitionElement).applyTo(new Applier.Opacity(0.3f)), new KeyframeAnimation(50, slotTransitionElement).applyTo(new Applier.Opacity(0.0f)));
    }

    private void changeCompartment(int index) {
        this.container.changeCompartment(index);
        this.compartmentButtons.setActive(index);
        this.slotTransition.stop();
        this.slotTransition.start();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        this.compartmentButtons.keyTyped(typedChar);
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_73876_c() {
        int size = TileEntityForgedContainer.compartmentSize;
        for (int i = 0; i < TileEntityForgedContainer.compartmentCount; ++i) {
            boolean hasContent = false;
            for (int j = 0; j < size; ++j) {
                if (this.tileEntity.func_70301_a(i * size + j).func_190926_b()) continue;
                hasContent = true;
                break;
            }
            this.compartmentButtons.setHasContent(i, hasContent);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.func_146979_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.gui.draw(x, y, this.field_146294_l, this.field_146295_m, mouseX, mouseY, 1.0f);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.gui.onClick(mouseX, mouseY);
    }
}

