/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.container;

import com.google.common.base.Predicates;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.forged.container.ChangeCompartmentPacket;
import se.mickelus.tetra.blocks.forged.container.GuiHandlerForgedContainer;
import se.mickelus.tetra.blocks.forged.container.ItemBlockForgedContainer;
import se.mickelus.tetra.blocks.forged.container.TileEntityForgedContainer;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IBlockCapabilityInteractive;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.items.TetraCreativeTabs;
import se.mickelus.tetra.network.GuiHandlerRegistry;
import se.mickelus.tetra.network.PacketHandler;

public class BlockForgedContainer
extends TetraBlock
implements ITileEntityProvider,
IBlockCapabilityInteractive {
    public static final PropertyDirection propFacing = BlockHorizontal.field_185512_D;
    public static final PropertyBool propFlipped = PropertyBool.func_177716_a((String)"flipped");
    public static final PropertyBool propLocked1 = PropertyBool.func_177716_a((String)"locked1");
    public static final PropertyBool propLocked2 = PropertyBool.func_177716_a((String)"locked2");
    public static final PropertyBool propLockedAdjacent = PropertyBool.func_177716_a((String)"adjacent");
    public static final PropertyBool propOpen = PropertyBool.func_177716_a((String)"open");
    public static final BlockInteraction[] interactions = new BlockInteraction[]{new BlockInteraction(Capability.hammer, 3, EnumFacing.SOUTH, 5.0f, 7.0f, 2.0f, 5.0f, new PropertyMatcher().where(propLocked1, Predicates.equalTo((Object)true)).where(propFlipped, Predicates.equalTo((Object)false)), BlockForgedContainer::breakLock0), new BlockInteraction(Capability.hammer, 3, EnumFacing.SOUTH, 11.0f, 13.0f, 2.0f, 5.0f, new PropertyMatcher().where(propLocked2, Predicates.equalTo((Object)true)).where(propFlipped, Predicates.equalTo((Object)false)), BlockForgedContainer::breakLock1), new BlockInteraction(Capability.hammer, 3, EnumFacing.SOUTH, 17.0f, 19.0f, 2.0f, 5.0f, new PropertyMatcher().where(propLocked1, Predicates.equalTo((Object)true)).where(propFlipped, Predicates.equalTo((Object)true)), BlockForgedContainer::breakLock2), new BlockInteraction(Capability.hammer, 3, EnumFacing.SOUTH, 23.0f, 25.0f, 2.0f, 5.0f, new PropertyMatcher().where(propLocked2, Predicates.equalTo((Object)true)).where(propFlipped, Predicates.equalTo((Object)true)), BlockForgedContainer::breakLock3), new BlockInteraction(Capability.pry, 1, EnumFacing.SOUTH, 1.0f, 15.0f, 3.0f, 4.0f, new PropertyMatcher().where(propLocked1, Predicates.equalTo((Object)false)).where(propLocked2, Predicates.equalTo((Object)false)).where(propLockedAdjacent, Predicates.equalTo((Object)false)).where(propOpen, Predicates.equalTo((Object)false)).where(propFlipped, Predicates.equalTo((Object)false)), BlockForgedContainer::open), new BlockInteraction(Capability.pry, 1, EnumFacing.SOUTH, 15.0f, 28.0f, 3.0f, 4.0f, new PropertyMatcher().where(propLocked1, Predicates.equalTo((Object)false)).where(propLocked2, Predicates.equalTo((Object)false)).where(propLockedAdjacent, Predicates.equalTo((Object)false)).where(propOpen, Predicates.equalTo((Object)false)).where(propFlipped, Predicates.equalTo((Object)true)), BlockForgedContainer::open)};
    private static AxisAlignedBB aabbZ1 = new AxisAlignedBB(0.0625, 0.0, -0.9375, 0.9375, 0.75, 0.9375);
    private static AxisAlignedBB aabbZ2 = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.75, 1.9375);
    private static AxisAlignedBB aabbX1 = new AxisAlignedBB(-0.9375, 0.0, 0.0625, 0.9375, 0.75, 0.9375);
    private static AxisAlignedBB aabbX2 = new AxisAlignedBB(0.0625, 0.0, 0.0625, 1.9375, 0.75, 0.9375);
    public static final String unlocalizedName = "forged_container";
    @GameRegistry.ObjectHolder(value="tetra:forged_container")
    public static BlockForgedContainer instance;

    public BlockForgedContainer() {
        super(Material.field_151573_f);
        this.setRegistryName(unlocalizedName);
        this.func_149663_c(unlocalizedName);
        GameRegistry.registerTileEntity(TileEntityForgedContainer.class, (ResourceLocation)new ResourceLocation("tetra", unlocalizedName));
        this.func_149647_a(TetraCreativeTabs.getInstance());
        this.func_149722_s();
        this.hasItem = true;
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)propFacing, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)propFlipped, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void init(PacketHandler packetHandler) {
        GuiHandlerRegistry.instance.registerHandler(2, new GuiHandlerForgedContainer());
        packetHandler.registerPacket(ChangeCompartmentPacket.class, Side.SERVER);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.clear();
    }

    @Override
    public void registerItem(IForgeRegistry<Item> registry) {
        ItemBlockForgedContainer item = new ItemBlockForgedContainer(this);
        item.setRegistryName(this.getRegistryName());
        registry.register((IForgeRegistryEntry)item);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"forged_description", (Object[])new Object[0]));
    }

    private static void breakLock(IBlockAccess world, BlockPos pos, EntityPlayer player, int index) {
        TileEntityForgedContainer te = (TileEntityForgedContainer)world.func_175625_s(pos);
        if (te != null) {
            te.getOrDelegate().breakLock(player, index);
        }
    }

    private static boolean breakLock0(IBlockAccess world, BlockPos pos, IBlockState blockState, EntityPlayer player, EnumHand hand, EnumFacing facing) {
        BlockForgedContainer.breakLock(world, pos, player, 0);
        return true;
    }

    private static boolean breakLock1(IBlockAccess world, BlockPos pos, IBlockState blockState, EntityPlayer player, EnumHand hand, EnumFacing facing) {
        BlockForgedContainer.breakLock(world, pos, player, 1);
        return true;
    }

    private static boolean breakLock2(IBlockAccess world, BlockPos pos, IBlockState blockState, EntityPlayer player, EnumHand hand, EnumFacing facing) {
        BlockForgedContainer.breakLock(world, pos, player, 2);
        return true;
    }

    private static boolean breakLock3(IBlockAccess world, BlockPos pos, IBlockState blockState, EntityPlayer player, EnumHand hand, EnumFacing facing) {
        BlockForgedContainer.breakLock(world, pos, player, 3);
        return true;
    }

    private static boolean open(IBlockAccess world, BlockPos pos, IBlockState blockState, EntityPlayer player, EnumHand hand, EnumFacing facing) {
        TileEntityForgedContainer te = (TileEntityForgedContainer)world.func_175625_s(pos);
        if (te != null) {
            te.getOrDelegate().open(player);
        }
        return true;
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(IBlockState state, EnumFacing face, Collection<Capability> capabilities) {
        return (BlockInteraction[])Arrays.stream(interactions).filter(interaction -> interaction.isPotentialInteraction(state, (EnumFacing)state.func_177229_b((IProperty)propFacing), face, capabilities)).toArray(BlockInteraction[]::new);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean didInteract = BlockInteraction.attemptInteraction(world, this.func_176221_a(world.func_180495_p(pos), (IBlockAccess)world, pos), pos, player, hand, facing, hitX, hitY, hitZ);
        if (!didInteract) {
            TileEntityForgedContainer te = (TileEntityForgedContainer)world.func_175625_s(pos);
            if (te != null && te.getOrDelegate().isOpen()) {
                player.openGui((Object)TetraMod.instance, 2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        } else {
            world.func_184138_a(pos, state, state, 3);
        }
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB aabb = null;
        state = this.func_176221_a(state, source, pos);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)propFacing);
        boolean flipped = (Boolean)state.func_177229_b((IProperty)propFlipped);
        boolean open = (Boolean)state.func_177229_b((IProperty)propOpen);
        if (flipped) {
            switch (facing) {
                case NORTH: {
                    aabb = aabbX1;
                    break;
                }
                case EAST: {
                    aabb = aabbZ1;
                    break;
                }
                case SOUTH: {
                    aabb = aabbX2;
                    break;
                }
                case WEST: {
                    aabb = aabbZ2;
                }
            }
        } else {
            switch (facing) {
                case NORTH: {
                    aabb = aabbX2;
                    break;
                }
                case EAST: {
                    aabb = aabbZ2;
                    break;
                }
                case SOUTH: {
                    aabb = aabbX1;
                    break;
                }
                case WEST: {
                    aabb = aabbZ1;
                }
            }
        }
        if (open && aabb != null) {
            aabb = aabb.func_186666_e(0.5625);
        }
        return aabb;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{propFacing, propFlipped, propLocked1, propLocked2, propLockedAdjacent, propOpen});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = super.getExtendedState(state, world, pos);
        TileEntityForgedContainer te = (TileEntityForgedContainer)world.func_175625_s(pos);
        if (te != null) {
            te = te.getOrDelegate();
            boolean anyLocked = Arrays.stream(te.getOrDelegate().isLocked()).anyMatch(isLocked -> isLocked);
            actualState = (Boolean)state.func_177229_b((IProperty)propFlipped) != false ? actualState.func_177226_a((IProperty)propLocked1, (Comparable)Boolean.valueOf(te.isLocked(2))).func_177226_a((IProperty)propLocked2, (Comparable)Boolean.valueOf(te.isLocked(3))) : actualState.func_177226_a((IProperty)propLocked1, (Comparable)Boolean.valueOf(te.isLocked(0))).func_177226_a((IProperty)propLocked2, (Comparable)Boolean.valueOf(te.isLocked(1)));
            actualState = actualState.func_177226_a((IProperty)propOpen, (Comparable)Boolean.valueOf(te.isOpen())).func_177226_a((IProperty)propLockedAdjacent, (Comparable)Boolean.valueOf(anyLocked));
        }
        return actualState;
    }

    public IBlockState func_176203_a(int meta) {
        return super.func_176223_P().func_177226_a((IProperty)propFacing, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)propFlipped, (Comparable)Boolean.valueOf((meta >> 2 & 1) == 1));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)propFacing)).func_176736_b() | ((Boolean)state.func_177229_b((IProperty)propFlipped) != false ? 4 : 0);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityForgedContainer();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState iblockstate = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        return iblockstate.func_177226_a((IProperty)propFacing, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)propFacing);
        worldIn.func_175656_a(pos.func_177972_a(facing.func_176746_e()), this.func_176223_P().func_177226_a((IProperty)propFlipped, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)propFacing, (Comparable)facing));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        BlockPos relativePos = (Boolean)state.func_177229_b((IProperty)propFlipped) != false ? pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)propFacing)).func_176735_f()) : pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)propFacing)).func_176746_e());
        if (!this.equals(world.func_180495_p(relativePos).func_177230_c())) {
            world.func_175698_g(pos);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)propFacing);
        if (Rotation.CLOCKWISE_180.equals((Object)rot) || Rotation.CLOCKWISE_90.equals((Object)rot) && (EnumFacing.NORTH.equals((Object)facing) || EnumFacing.SOUTH.equals((Object)facing)) || Rotation.COUNTERCLOCKWISE_90.equals((Object)rot) && (EnumFacing.EAST.equals((Object)facing) || EnumFacing.WEST.equals((Object)facing))) {
            state = state.func_177226_a((IProperty)propFlipped, state.func_177229_b((IProperty)propFlipped));
        }
        return state.func_177226_a((IProperty)propFacing, (Comparable)rot.func_185831_a(facing));
    }
}

