/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.mickelus.tetra.blocks.Materials;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.items.TetraCreativeTabs;

public class BlockForgedPlatformSlab
extends TetraBlock {
    public static final PropertyEnum<BlockSlab.EnumBlockHalf> halfProp = PropertyEnum.func_177709_a((String)"half", BlockSlab.EnumBlockHalf.class);
    protected static final AxisAlignedBB AABB_BOTTOM_HALF = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_TOP_HALF = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    static final String unlocalizedName = "forged_platform_slab";
    @GameRegistry.ObjectHolder(value="tetra:forged_platform_slab")
    public static BlockForgedPlatformSlab instance;

    public BlockForgedPlatformSlab() {
        super(Materials.forged);
        this.setRegistryName(unlocalizedName);
        this.func_149663_c(unlocalizedName);
        this.func_149647_a(TetraCreativeTabs.getInstance());
        this.func_149722_s();
        this.hasItem = true;
        this.field_149787_q = false;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(halfProp, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"forged_description", (Object[])new Object[0]));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.clear();
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (explosion.getPosition().field_72448_b < (double)pos.func_177956_o()) {
            return 4.0f;
        }
        return 6.0f;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{halfProp});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(halfProp, (Comparable)(meta == 1 ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM));
    }

    public int func_176201_c(IBlockState state) {
        if (state.func_177229_b(halfProp) == BlockSlab.EnumBlockHalf.TOP) {
            return 1;
        }
        return 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return state.func_177229_b(halfProp) == BlockSlab.EnumBlockHalf.TOP ? AABB_TOP_HALF : AABB_BOTTOM_HALF;
    }

    public boolean func_185481_k(IBlockState state) {
        return state.func_177229_b(halfProp) == BlockSlab.EnumBlockHalf.TOP;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.UP && state.func_177229_b(halfProp) == BlockSlab.EnumBlockHalf.TOP) {
            return BlockFaceShape.SOLID;
        }
        if (face == EnumFacing.DOWN && state.func_177229_b(halfProp) == BlockSlab.EnumBlockHalf.BOTTOM) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (ForgeModContainer.disableStairSlabCulling) {
            return false;
        }
        BlockSlab.EnumBlockHalf side = (BlockSlab.EnumBlockHalf)state.func_177229_b(halfProp);
        return side == BlockSlab.EnumBlockHalf.TOP && face == EnumFacing.UP || side == BlockSlab.EnumBlockHalf.BOTTOM && face == EnumFacing.DOWN;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(halfProp, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? iblockstate : iblockstate.func_177226_a(halfProp, (Comparable)BlockSlab.EnumBlockHalf.TOP);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (super.func_176225_a(blockState, blockAccess, pos, side)) {
            return true;
        }
        return side == EnumFacing.UP || side == EnumFacing.DOWN;
    }
}

