/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import se.mickelus.tetra.blocks.ITetraBlock;
import se.mickelus.tetra.blocks.Materials;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IBlockCapabilityInteractive;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.items.TetraCreativeTabs;
import se.mickelus.tetra.module.ItemEffectHandler;
import se.mickelus.tetra.util.CastOptional;

public class BlockForgedCrate
extends BlockFalling
implements ITetraBlock,
IBlockCapabilityInteractive {
    public static final PropertyDirection propFacing = BlockHorizontal.field_185512_D;
    public static final PropertyBool propStacked = PropertyBool.func_177716_a((String)"stacked");
    public static final PropertyInteger propIntegrity = PropertyInteger.func_177719_a((String)"integrity", (int)0, (int)3);
    static final BlockInteraction[] interactions = new BlockInteraction[]{new BlockInteraction(Capability.pry, 1, EnumFacing.EAST, 6.0f, 8.0f, 6.0f, 8.0f, (Predicate<IBlockState>)BlockStateMatcher.field_185928_a, BlockForgedCrate::attemptBreakPry), new BlockInteraction(Capability.hammer, 3, EnumFacing.EAST, 1.0f, 4.0f, 1.0f, 4.0f, (Predicate<IBlockState>)BlockStateMatcher.field_185928_a, BlockForgedCrate::attemptBreakHammer), new BlockInteraction(Capability.hammer, 3, EnumFacing.EAST, 10.0f, 13.0f, 10.0f, 13.0f, (Predicate<IBlockState>)BlockStateMatcher.field_185928_a, BlockForgedCrate::attemptBreakHammer)};
    static final String unlocalizedName = "forged_crate";
    @GameRegistry.ObjectHolder(value="tetra:forged_crate")
    public static BlockForgedCrate instance;
    public static final ResourceLocation crateLootTable;

    public BlockForgedCrate() {
        super(Materials.forgedCrate);
        this.setRegistryName(unlocalizedName);
        this.func_149663_c(unlocalizedName);
        this.func_149647_a(TetraCreativeTabs.getInstance());
        this.func_149711_c(10.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)propFacing, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)propStacked, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)propIntegrity, (Comparable)Integer.valueOf(3)));
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return 1.0f;
    }

    private static boolean attemptBreakHammer(World world, BlockPos pos, IBlockState blockState, EntityPlayer player, EnumHand hand, EnumFacing facing) {
        return BlockForgedCrate.attemptBreak(world, pos, blockState, player, player.func_184586_b(hand), Capability.hammer, 2, 1);
    }

    private static boolean attemptBreakPry(World world, BlockPos pos, IBlockState blockState, EntityPlayer player, EnumHand hand, EnumFacing facing) {
        return BlockForgedCrate.attemptBreak(world, pos, blockState, player, player.func_184586_b(hand), Capability.pry, 0, 2);
    }

    private static boolean attemptBreak(World world, BlockPos pos, IBlockState blockState, EntityPlayer player, ItemStack itemStack, Capability capability, int min, int multiplier) {
        int progress;
        int integrity = (Integer)blockState.func_177229_b((IProperty)propIntegrity);
        if (integrity - (progress = CastOptional.cast(itemStack.func_77973_b(), ItemModular.class).map(item -> item.getCapabilityLevel(itemStack, capability)).map(level -> (level - min) * multiplier).orElse(1).intValue()) >= 0) {
            if (Capability.hammer.equals((Object)capability)) {
                world.func_184133_a(player, pos, SoundEvents.field_187928_hb, SoundCategory.PLAYERS, 1.0f, 0.5f);
            } else {
                world.func_184133_a(player, pos, SoundEvents.field_187653_cW, SoundCategory.PLAYERS, 0.7f, 2.0f);
            }
            world.func_175656_a(pos, blockState.func_177226_a((IProperty)propIntegrity, (Comparable)Integer.valueOf(integrity - progress)));
        } else {
            world.func_180498_a(player, 2001, pos, Block.func_176210_f((IBlockState)blockState));
            ItemEffectHandler.breakBlock(world, player, itemStack, pos, blockState);
        }
        return true;
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(IBlockState state, EnumFacing face, Collection<Capability> capabilities) {
        return interactions;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return BlockInteraction.attemptInteraction(world, state.func_185899_b((IBlockAccess)world, pos), pos, player, hand, facing, hitX, hitY, hitZ);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        CastOptional.cast(world, WorldServer.class).ifPresent(worldServer -> {
            LootTable table = worldServer.func_184146_ak().func_186521_a(crateLootTable);
            LootContext.Builder builder = new LootContext.Builder(worldServer);
            drops.addAll((Collection)table.func_186462_a(worldServer.field_73012_v, builder.func_186471_a()));
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"forged_description", (Object[])new Object[0]));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{propFacing, propStacked, propIntegrity});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)propFacing, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (this.equals(worldIn.func_180495_p(pos.func_177977_b()).func_177230_c())) {
            return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)propStacked, (Comparable)Boolean.valueOf(true));
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState blockState = this.func_176223_P();
        int facingIndex = meta & 3;
        if (facingIndex < EnumFacing.field_176754_o.length) {
            blockState = blockState.func_177226_a((IProperty)propFacing, (Comparable)EnumFacing.field_176754_o[facingIndex]);
        }
        return blockState.func_177226_a((IProperty)propIntegrity, (Comparable)Integer.valueOf(meta >> 2));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)propFacing)).func_176736_b() | (Integer)state.func_177229_b((IProperty)propIntegrity) << 2;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)propFacing, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)propFacing)));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB aabb = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375).func_191194_a(new Vec3d(((EnumFacing)state.func_177229_b((IProperty)propFacing)).func_176730_m()).func_186678_a(0.0625));
        if (((Boolean)this.func_176221_a(state, source, pos).func_177229_b((IProperty)propStacked)).booleanValue()) {
            return aabb.func_72317_d(0.0, -0.125, 0.0);
        }
        return aabb;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    @Override
    public boolean hasItem() {
        return true;
    }

    @Override
    public void registerItem(IForgeRegistry<Item> registry) {
        this.registerItem(registry, (Block)this);
    }

    static {
        crateLootTable = new ResourceLocation("tetra", "forged/crate_break");
    }
}

