/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.advancements.critereon.ItemPredicates;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ArrayUtils;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.PotionBleeding;
import se.mickelus.tetra.PotionEarthbound;
import se.mickelus.tetra.advancements.BlockInteractionCriterion;
import se.mickelus.tetra.advancements.BlockLookTrigger;
import se.mickelus.tetra.advancements.BlockUseCriterion;
import se.mickelus.tetra.advancements.ImprovementCraftCriterion;
import se.mickelus.tetra.advancements.ModuleCraftCriterion;
import se.mickelus.tetra.blocks.ITetraBlock;
import se.mickelus.tetra.blocks.forged.BlockForgedCrate;
import se.mickelus.tetra.blocks.forged.BlockForgedPillar;
import se.mickelus.tetra.blocks.forged.BlockForgedPlatform;
import se.mickelus.tetra.blocks.forged.BlockForgedPlatformSlab;
import se.mickelus.tetra.blocks.forged.BlockForgedVent;
import se.mickelus.tetra.blocks.forged.BlockForgedWall;
import se.mickelus.tetra.blocks.forged.container.BlockForgedContainer;
import se.mickelus.tetra.blocks.forged.extractor.BlockCoreExtractorBase;
import se.mickelus.tetra.blocks.forged.extractor.BlockCoreExtractorPipe;
import se.mickelus.tetra.blocks.forged.extractor.BlockCoreExtractorPiston;
import se.mickelus.tetra.blocks.forged.extractor.BlockSeepingBedrock;
import se.mickelus.tetra.blocks.forged.transfer.BlockTransferUnit;
import se.mickelus.tetra.blocks.geode.BlockGeode;
import se.mickelus.tetra.blocks.geode.ItemGeode;
import se.mickelus.tetra.blocks.geode.ItemPristineDiamond;
import se.mickelus.tetra.blocks.geode.ItemPristineEmerald;
import se.mickelus.tetra.blocks.geode.ItemPristineLapis;
import se.mickelus.tetra.blocks.hammer.BlockHammerBase;
import se.mickelus.tetra.blocks.hammer.BlockHammerHead;
import se.mickelus.tetra.blocks.workbench.BlockWorkbench;
import se.mickelus.tetra.data.DataHandler;
import se.mickelus.tetra.generation.TGenCommand;
import se.mickelus.tetra.generation.WorldGenFeatures;
import se.mickelus.tetra.items.ITetraItem;
import se.mickelus.tetra.items.ItemPredicateModular;
import se.mickelus.tetra.items.TetraCreativeTabs;
import se.mickelus.tetra.items.cell.ItemCellMagmatic;
import se.mickelus.tetra.items.duplex_tool.ItemDuplexToolModular;
import se.mickelus.tetra.items.forged.ItemBeam;
import se.mickelus.tetra.items.forged.ItemBolt;
import se.mickelus.tetra.items.forged.ItemMesh;
import se.mickelus.tetra.items.forged.ItemMetalScrap;
import se.mickelus.tetra.items.forged.ItemQuickLatch;
import se.mickelus.tetra.items.forged.ItemVentPlate;
import se.mickelus.tetra.items.journal.ItemJournal;
import se.mickelus.tetra.items.sword.ItemSwordModular;
import se.mickelus.tetra.items.toolbelt.ItemToolbeltModular;
import se.mickelus.tetra.loot.FortuneBonusCondition;
import se.mickelus.tetra.loot.FortuneBonusFunction;
import se.mickelus.tetra.loot.SetMetadataFunction;
import se.mickelus.tetra.module.ItemEffectHandler;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.improvement.DestabilizationEffect;
import se.mickelus.tetra.module.improvement.HonePacket;
import se.mickelus.tetra.module.improvement.SettlePacket;
import se.mickelus.tetra.module.schema.CleanseSchema;
import se.mickelus.tetra.network.GuiHandlerRegistry;
import se.mickelus.tetra.network.PacketHandler;
import se.mickelus.tetra.proxy.IProxy;

@Mod(useMetadata=true, modid="tetra", version="0.39.1", acceptedMinecraftVersions="[1.12.2]")
public class TetraMod {
    public static final String MOD_ID = "tetra";
    @SidedProxy(clientSide="se.mickelus.tetra.proxy.ClientProxy", serverSide="se.mickelus.tetra.proxy.ServerProxy")
    public static IProxy proxy;
    @Mod.Instance(value="tetra")
    public static TetraMod instance;
    private Item[] items;
    private Block[] blocks;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ItemPredicates.register((ResourceLocation)new ResourceLocation("tetra:modular_item"), ItemPredicateModular::new);
        LootConditionManager.func_186639_a((LootCondition.Serializer)new FortuneBonusCondition.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new FortuneBonusFunction.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new SetMetadataFunction.Serializer());
        new DataHandler(event.getSourceFile());
        new ItemUpgradeRegistry();
        new TetraCreativeTabs();
        new GuiHandlerRegistry();
        CriteriaTriggers.func_192118_a((ICriterionTrigger)BlockLookTrigger.instance);
        CriteriaTriggers.func_192118_a(BlockUseCriterion.trigger);
        CriteriaTriggers.func_192118_a(BlockInteractionCriterion.trigger);
        CriteriaTriggers.func_192118_a(ModuleCraftCriterion.trigger);
        CriteriaTriggers.func_192118_a(ImprovementCraftCriterion.trigger);
        MinecraftForge.EVENT_BUS.register((Object)new ItemEffectHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        MinecraftForge.EVENT_BUS.register((Object)BlockLookTrigger.instance);
        this.blocks = new Block[]{new BlockWorkbench(), new BlockGeode()};
        if (ConfigHandler.generateFeatures) {
            this.blocks = (Block[])ArrayUtils.addAll((Object[])this.blocks, (Object[])new Block[]{new BlockHammerHead(), new BlockHammerBase(), new BlockForgedWall(), new BlockForgedPillar(), new BlockForgedPlatform(), new BlockForgedPlatformSlab(), new BlockForgedVent(), new BlockForgedContainer(), new BlockForgedCrate(), new BlockTransferUnit(), new BlockCoreExtractorBase(), new BlockCoreExtractorPiston(), new BlockCoreExtractorPipe(), new BlockSeepingBedrock()});
        }
        this.items = new Item[]{new ItemSwordModular(), new ItemGeode(), new ItemPristineLapis(), new ItemPristineEmerald(), new ItemPristineDiamond(), new ItemToolbeltModular(), new ItemDuplexToolModular(), new ItemCellMagmatic(), new ItemBolt(), new ItemBeam(), new ItemMesh(), new ItemQuickLatch(), new ItemMetalScrap(), new ItemVentPlate(), new ItemJournal()};
        ForgeRegistries.POTIONS.registerAll((IForgeRegistryEntry[])new Potion[]{new PotionBleeding()});
        ForgeRegistries.POTIONS.registerAll((IForgeRegistryEntry[])new Potion[]{new PotionEarthbound()});
        proxy.preInit(event, (ITetraItem[])Arrays.stream(this.items).filter(item -> item instanceof ITetraItem).map(item -> (ITetraItem)item).toArray(ITetraItem[]::new), (ITetraBlock[])Arrays.stream(this.blocks).filter(block -> block instanceof ITetraBlock).map(block -> (ITetraBlock)block).toArray(ITetraBlock[]::new));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        if (ConfigHandler.generateFeatures) {
            WorldGenFeatures worldGenFeatures = new WorldGenFeatures();
            GameRegistry.registerWorldGenerator((IWorldGenerator)worldGenFeatures, (int)11);
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)GuiHandlerRegistry.instance);
        PacketHandler packetHandler = new PacketHandler();
        Arrays.stream(this.items).filter(item -> item instanceof ITetraItem).map(item -> (ITetraItem)item).forEach(item -> item.init(packetHandler));
        Arrays.stream(this.blocks).filter(block -> block instanceof ITetraBlock).map(block -> (ITetraBlock)block).forEach(block -> block.init(packetHandler));
        packetHandler.registerPacket(HonePacket.class, Side.CLIENT);
        packetHandler.registerPacket(SettlePacket.class, Side.CLIENT);
        DestabilizationEffect.LoadEffects();
        new CleanseSchema();
    }

    @SubscribeEvent
    public void lootTableLoad(LootTableLoadEvent event) {
        if (MOD_ID.equals(event.getName().func_110624_b())) {
            LootTable lootTable = event.getTable();
            LootPool[] extendedPools = DataHandler.instance.getExtendedLootPools(event.getName());
            Optional.ofNullable(extendedPools).map(Arrays::stream).orElseGet(Stream::empty).forEach(arg_0 -> ((LootTable)lootTable).addPool(arg_0));
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new TGenCommand());
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])this.blocks);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])this.items);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            Arrays.stream(this.items).forEach(item -> ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory")));
        }
        Arrays.stream(this.blocks).filter(block -> block instanceof ITetraBlock).map(block -> (ITetraBlock)block).filter(ITetraBlock::hasItem).forEach(block -> block.registerItem((IForgeRegistry<Item>)event.getRegistry()));
    }
}

