/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.tile;

import com.feed_the_beast.ftblib.lib.config.ConfigBlockState;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigNull;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.block.BlockTaskScreen;
import com.feed_the_beast.ftbquests.block.FTBQuestsBlocks;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.tile.ITaskScreen;
import com.feed_the_beast.ftbquests.tile.TileTaskScreenPart;
import com.feed_the_beast.ftbquests.tile.TileWithTeam;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import com.latmod.mods.itemfilters.api.PaintAPI;
import javax.annotation.Nullable;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileTaskScreenCore
extends TileWithTeam
implements IConfigCallback,
ITaskScreen {
    public EnumFacing facing;
    public int task = 0;
    public int size = 0;
    public IBlockState skin = BlockUtils.AIR_STATE;
    public boolean inputOnly = false;
    public ItemStack inputModeIcon = ItemStack.field_190927_a;
    private Class currentCoreClass;
    private Class currentPartClass;

    @Override
    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
        super.writeData(nbt, type);
        if (!type.item) {
            nbt.func_74778_a("Facing", this.getFacing().func_176610_l());
        }
        if (this.task != 0) {
            nbt.func_74768_a("Task", this.task);
        }
        if (this.size > 0) {
            nbt.func_74774_a("Size", (byte)this.size);
        }
        if (this.skin != BlockUtils.AIR_STATE) {
            nbt.func_74778_a("Skin", BlockUtils.getNameFromState((IBlockState)this.skin));
        }
        if (this.inputOnly) {
            nbt.func_74757_a("InputOnly", true);
        }
        if (!this.inputModeIcon.func_190926_b()) {
            nbt.func_74782_a("InputModeIcon", (NBTBase)this.inputModeIcon.serializeNBT());
        }
    }

    @Override
    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
        super.readData(nbt, type);
        if (!type.item) {
            this.facing = EnumFacing.func_176739_a((String)nbt.func_74779_i("Facing"));
        }
        this.task = nbt.func_74762_e("Task");
        this.size = nbt.func_74771_c("Size");
        this.skin = BlockUtils.getStateFromName((String)nbt.func_74779_i("Skin"));
        this.inputOnly = nbt.func_74767_n("InputOnly");
        this.inputModeIcon = new ItemStack(nbt.func_74775_l("InputModeIcon"));
        if (this.inputModeIcon.func_190926_b()) {
            this.inputModeIcon = ItemStack.field_190927_a;
        }
        this.func_145836_u();
    }

    public final void resetData() {
        this.team = "";
        this.indestructible = false;
        this.facing = null;
        this.task = 0;
        this.size = 0;
        this.skin = BlockUtils.AIR_STATE;
        this.inputOnly = false;
        this.inputModeIcon = ItemStack.field_190927_a;
        this.func_145836_u();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == PaintAPI.CAPABILITY) {
            return true;
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            TaskData t = this.getTaskData();
            if (t == null || !((Task)t.task).quest.canStartTasks(t.data)) {
                return false;
            }
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && ((Task)t.task).canInsertItem()) {
                return true;
            }
            if (t.hasCapability(capability, facing)) {
                return true;
            }
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == PaintAPI.CAPABILITY) {
            return (T)this;
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            TaskData t = this.getTaskData();
            if (t == null || !((Task)t.task).quest.canStartTasks(t.data)) {
                return null;
            }
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && ((Task)t.task).canInsertItem()) {
                return (T)t;
            }
            T object = t.getCapability(capability, facing);
            if (object != null) {
                return object;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public EnumFacing getFacing() {
        if (this.facing == null) {
            IBlockState state = this.getBlockState();
            this.facing = state.func_177230_c() == FTBQuestsBlocks.SCREEN ? (EnumFacing)this.getBlockState().func_177229_b((IProperty)BlockHorizontal.field_185512_D) : EnumFacing.NORTH;
        }
        return this.facing;
    }

    @Override
    public TileTaskScreenCore getScreen() {
        return this;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.facing = null;
    }

    protected boolean notifyBlock() {
        return !this.field_145850_b.field_72995_K;
    }

    @Nullable
    public TaskData getTaskData() {
        if (this.task == 0 || this.team.isEmpty()) {
            return null;
        }
        QuestFile file = FTBQuests.PROXY.getQuestFile(this.field_145850_b);
        if (file == null) {
            return null;
        }
        Task t = file.getTask(this.task);
        if (t == null) {
            return null;
        }
        QuestData data = file.getData(this.team);
        if (data == null) {
            return null;
        }
        return data.getTaskData(t);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return BlockTaskScreen.getScreenAABB(this.field_174879_c, this.getFacing(), this.size);
    }

    public double func_145833_n() {
        double d = 32.0 * (double)(2 + this.size);
        return d * d;
    }

    public void onClicked(EntityPlayerMP player, EnumHand hand, double x, double y) {
        boolean editor = FTBQuests.canEdit((EntityPlayer)player);
        if (editor || this.isOwner((EntityPlayer)player)) {
            TaskData taskData = this.getTaskData();
            if (taskData != null) {
                this.task = ((Task)taskData.task).id;
                this.currentCoreClass = ((Task)taskData.task).getScreenCoreClass();
                this.currentPartClass = ((Task)taskData.task).getScreenPartClass();
            } else {
                this.currentCoreClass = TileTaskScreenCore.class;
                this.currentPartClass = TileTaskScreenPart.class;
            }
            boolean editorOrDestructible = editor || !this.indestructible;
            ConfigGroup group0 = ConfigGroup.newGroup((String)"tile");
            group0.setDisplayName((ITextComponent)new TextComponentTranslation("tile.ftbquests.screen.name", new Object[0]));
            ConfigGroup config = group0.getGroup("ftbquests.screen");
            if (editor) {
                config.add("team", (ConfigValue)this.createTeamConfig(), (ConfigValue)ConfigNull.INSTANCE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.team", new Object[0]));
            }
            config.add("task", (ConfigValue)new ConfigQuestObject(ServerQuestFile.INSTANCE, this.task, o -> o instanceof Task && ((Task)o).consumesResources()){

                @Override
                public void setObject(int v) {
                    TileTaskScreenCore.this.task = v;
                }
            }, (ConfigValue)ConfigNull.INSTANCE).setCanEdit(editorOrDestructible).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.task", new Object[0]));
            config.add("skin", (ConfigValue)new ConfigBlockState(this.skin){

                public void setBlockState(IBlockState v) {
                    TileTaskScreenCore.this.skin = v;
                }
            }, (ConfigValue)new ConfigBlockState(BlockUtils.AIR_STATE)).setCanEdit(editorOrDestructible);
            if (editor) {
                config.addBool("indestructible", () -> this.indestructible, v -> {
                    this.indestructible = v;
                }, false);
            }
            config.addBool("input_only", () -> this.inputOnly, v -> {
                this.inputOnly = v;
            }, false);
            config.add("input_mode_icon", (ConfigValue)new ConfigItemStack.SimpleStack(() -> this.inputModeIcon, v -> {
                this.inputModeIcon = v;
            }), (ConfigValue)new ConfigItemStack(ItemStack.field_190927_a));
            FTBLibAPI.editServerConfig((EntityPlayerMP)player, (ConfigGroup)group0, (IConfigCallback)this);
        }
    }

    public void updateTiles(@Nullable Task task) {
        boolean xaxis = this.getFacing().func_176740_k() == EnumFacing.Axis.X;
        for (int by = 0; by < this.size * 2 + 1; ++by) {
            for (int bx = -this.size; bx <= this.size; ++bx) {
                int offX = xaxis ? 0 : bx;
                int offZ = xaxis ? bx : 0;
                BlockPos pos1 = new BlockPos(this.field_174879_c.func_177958_n() + offX, this.field_174879_c.func_177956_o() + by, this.field_174879_c.func_177952_p() + offZ);
                this.field_145850_b.func_175713_t(pos1);
                if (bx == 0 && by == 0) {
                    TileTaskScreenCore core = task == null ? new TileTaskScreenCore() : task.createScreenCore(this.field_145850_b);
                    core.func_145834_a(this.field_145850_b);
                    core.func_174878_a(pos1);
                    NBTTagCompound nbt = new NBTTagCompound();
                    this.writeData(nbt, EnumSaveType.SAVE);
                    core.readData(nbt, EnumSaveType.SAVE);
                    core.func_145829_t();
                    this.field_145850_b.func_175690_a(pos1, (TileEntity)core);
                    continue;
                }
                TileTaskScreenPart part = task == null ? new TileTaskScreenPart() : task.createScreenPart(this.field_145850_b);
                part.func_145834_a(this.field_145850_b);
                part.func_174878_a(pos1);
                part.setOffset(offX, by, offZ);
                part.func_145829_t();
                this.field_145850_b.func_175690_a(pos1, (TileEntity)part);
            }
        }
    }

    public void onConfigSaved(ConfigGroup group, ICommandSender sender) {
        this.func_145836_u();
        this.func_70296_d();
        BlockUtils.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c, (IBlockState)this.getBlockState());
        TaskData taskData = this.getTaskData();
        if (taskData != null && (this.currentCoreClass != ((Task)taskData.task).getScreenCoreClass() || this.currentPartClass != ((Task)taskData.task).getScreenPartClass())) {
            this.updateTiles((Task)taskData.task);
        }
    }

    public void onLoad() {
        if (this.func_145838_q() != FTBQuestsBlocks.SCREEN) {
            boolean xaxis = this.getFacing().func_176740_k() == EnumFacing.Axis.X;
            for (int y = 0; y < this.size * 2 + 1; ++y) {
                for (int x = -this.size; x <= this.size; ++x) {
                    int offX = xaxis ? 0 : x;
                    int offZ = xaxis ? x : 0;
                    this.field_145850_b.func_175698_g(new BlockPos(this.field_174879_c.func_177958_n() + offX, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + offZ));
                }
            }
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
        this.sendDirtyUpdate();
    }
}

