/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.tile;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigNull;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.tile.TileBase;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import com.feed_the_beast.ftbquests.util.ServerQuestData;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileRewardCollector
extends TileBase
implements ITickable,
IConfigCallback {
    public UUID owner = null;
    public int reward = 0;
    public ItemStackHandler inventory = new ItemStackHandler(9);

    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
        nbt.func_74768_a("reward", this.reward);
        if (!type.save) {
            return;
        }
        nbt.func_74778_a("owner", StringUtils.fromUUID((UUID)this.owner));
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
    }

    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
        this.reward = nbt.func_74762_e("reward");
        if (!type.save) {
            return;
        }
        this.owner = nbt.func_74764_b("owner") ? StringUtils.fromString((String)nbt.func_74779_i("owner")) : null;
        this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : super.getCapability(capability, facing));
    }

    public void func_70296_d() {
        this.sendDirtyUpdate();
    }

    private static long longHashCode(Object ... objects) {
        long result = 1L;
        for (Object element : objects) {
            result = 31L * result + (element == null ? 0L : (element instanceof Number ? ((Number)element).longValue() : (long)element.hashCode()));
        }
        return result;
    }

    public void func_73660_a() {
        if (this.owner == null || this.reward == 0 || this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        Reward r = ServerQuestFile.INSTANCE.getReward(this.reward);
        if (r == null || !r.quest.canRepeat) {
            return;
        }
        ServerQuestData data = ServerQuestFile.INSTANCE.getData(this.owner);
        if (data != null) {
            ArrayList<ItemStack> stacks;
            EntityPlayerMP player = this.field_145850_b.func_73046_m().func_184103_al().func_177451_a(this.owner);
            if (!data.isRewardClaimed(this.owner, r) && r.quest.isComplete(data) && r.automatedClaimPre((TileEntity)this, stacks = new ArrayList<ItemStack>(), this.field_145850_b.field_73012_v, this.owner, player)) {
                ItemStackHandler handler1 = new ItemStackHandler(this.inventory.getSlots());
                for (int i = 0; i < this.inventory.getSlots(); ++i) {
                    handler1.setStackInSlot(i, this.inventory.getStackInSlot(i));
                }
                for (ItemStack stack : stacks) {
                    if (ItemHandlerHelper.insertItem((IItemHandler)handler1, (ItemStack)stack, (boolean)false).func_190926_b()) continue;
                    return;
                }
                for (ItemStack stack : stacks) {
                    ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)stack, (boolean)false);
                }
                r.automatedClaimPost((TileEntity)this, this.owner, player);
                data.setRewardClaimed(this.owner, r);
            }
        }
    }

    public void onConfigSaved(ConfigGroup group, ICommandSender sender) {
    }

    public void onRightClick(EntityPlayerMP player) {
        if (!this.owner.equals(player.func_110124_au())) {
            return;
        }
        ConfigGroup group0 = ConfigGroup.newGroup((String)"tile");
        group0.setDisplayName((ITextComponent)new TextComponentTranslation("tile.ftbquests.reward_collector.name", new Object[0]));
        ConfigGroup config = group0.getGroup("ftbquests.reward_collector");
        config.add("reward", (ConfigValue)new ConfigQuestObject(ServerQuestFile.INSTANCE, this.reward, o -> o instanceof Reward && ((Reward)o).quest.canRepeat && ((Reward)o).automatedClaimPre((TileEntity)this, new ArrayList<ItemStack>(), this.field_145850_b.field_73012_v, this.owner, player)){

            @Override
            public void setObject(int v) {
                TileRewardCollector.this.reward = v;
            }
        }, (ConfigValue)ConfigNull.INSTANCE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward", new Object[0]));
        FTBLibAPI.editServerConfig((EntityPlayerMP)player, (ConfigGroup)group0, (IConfigCallback)this);
    }
}

