/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.tile;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigNull;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.task.CustomTask;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.tile.IHasConfig;
import com.feed_the_beast.ftbquests.tile.TileWithTeam;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileRedstoneDetector
extends TileWithTeam
implements IHasConfig {
    public int task = 0;
    public int requiredRedstone = 1;
    public int currentRedstone = 0;
    public boolean notifications = true;

    @Override
    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
        super.writeData(nbt, type);
        nbt.func_74768_a("task", this.task);
        nbt.func_74774_a("required_redstone", (byte)this.requiredRedstone);
        nbt.func_74774_a("current_redstone", (byte)this.currentRedstone);
        nbt.func_74757_a("notifications", this.notifications);
    }

    @Override
    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
        super.readData(nbt, type);
        this.task = nbt.func_74762_e("task");
        this.requiredRedstone = nbt.func_74771_c("required_redstone");
        this.currentRedstone = nbt.func_74771_c("current_redstone");
        this.notifications = nbt.func_74767_n("notifications");
    }

    public void checkRedstone() {
        Task t;
        int prev = this.currentRedstone;
        this.currentRedstone = this.field_145850_b.func_175687_A(this.field_174879_c);
        if (prev != this.currentRedstone && this.currentRedstone >= this.requiredRedstone && !this.field_145850_b.field_72995_K && (t = ServerQuestFile.INSTANCE.getTask(this.task)) != null) {
            QuestData data;
            QuestFile file = FTBQuests.PROXY.getQuestFile(this.field_145850_b);
            QuestData questData = data = file == null ? null : file.getData(this.team);
            if (data != null && !t.isComplete(data) && t.quest.canStartTasks(data)) {
                t.forceProgress(data, ChangeProgress.COMPLETE, this.notifications);
            }
        }
    }

    @Override
    public void editConfig(EntityPlayerMP player, boolean editor) {
        if (!editor) {
            return;
        }
        ConfigGroup group0 = ConfigGroup.newGroup((String)"tile");
        group0.setDisplayName((ITextComponent)new TextComponentTranslation("tile.ftbquests.detector.redstone.name", new Object[0]));
        ConfigGroup config = group0.getGroup("ftbquests.detector.redstone");
        config.add("team", (ConfigValue)this.createTeamConfig(), (ConfigValue)ConfigNull.INSTANCE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.team", new Object[0]));
        config.add("task", (ConfigValue)new ConfigQuestObject(ServerQuestFile.INSTANCE, this.task, CustomTask.PREDICATE){

            @Override
            public void setObject(int v) {
                TileRedstoneDetector.this.task = v;
            }
        }, (ConfigValue)new ConfigQuestObject((QuestFile)ServerQuestFile.INSTANCE, 0, CustomTask.PREDICATE)).setDisplayName((ITextComponent)new TextComponentTranslation("tile.ftbquests.detector.task", new Object[0]));
        config.addInt("required_redstone", () -> this.requiredRedstone, v -> {
            this.requiredRedstone = v;
        }, 1, 1, 15);
        config.addBool("notifications", () -> this.notifications, v -> {
            this.notifications = v;
        }, true).setDisplayName((ITextComponent)new TextComponentTranslation("tile.ftbquests.detector.notifications", new Object[0]));
        FTBLibAPI.editServerConfig((EntityPlayerMP)player, (ConfigGroup)group0, (IConfigCallback)this);
    }

    public void onConfigSaved(ConfigGroup group, ICommandSender sender) {
        this.func_70296_d();
    }

    @Override
    public void setIDFromPlacer(EntityLivingBase placer) {
        super.setIDFromPlacer(placer);
        this.checkRedstone();
    }
}

