/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.net.MessageSubmitTask;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CustomTask
extends Task {
    public static final Predicate<QuestObjectBase> PREDICATE = object -> object instanceof CustomTask;
    public Check check = null;
    public int checkTimer = 1;
    public long maxProgress = 1L;
    public boolean enableButton = false;

    public CustomTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.CUSTOM;
    }

    @Override
    public long getMaxProgress() {
        return this.maxProgress;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClicked(boolean canClick) {
        if (this.enableButton && canClick) {
            GuiHelper.playClickSound();
            new MessageSubmitTask(this.id).sendToServer();
        }
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return this.check == null ? 0 : this.checkTimer;
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarInt(this.checkTimer);
        data.writeVarLong(this.maxProgress);
        data.writeBoolean(this.enableButton);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.checkTimer = data.readVarInt();
        this.maxProgress = data.readVarLong();
        this.enableButton = data.readBoolean();
    }

    @Override
    public TaskData createData(QuestData data) {
        return new Data(this, data);
    }

    public static class Data
    extends TaskData<CustomTask> {
        private Data(CustomTask task, QuestData data) {
            super(task, data);
        }

        @Override
        public void submitTask(EntityPlayerMP player, ItemStack item) {
            if (((CustomTask)this.task).check != null && !this.isComplete()) {
                ((CustomTask)this.task).check.check(this, player);
            }
        }
    }

    @FunctionalInterface
    public static interface Check {
        public void check(Data var1, EntityPlayerMP var2);
    }
}

