/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.EnumTristate;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfig;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.io.Bits;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.client.FTBQuestsClient;
import com.feed_the_beast.ftbquests.item.FTBQuestsItems;
import com.feed_the_beast.ftbquests.net.edit.MessageChangeProgressResponse;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.ftbquests.util.QuestObjectText;
import com.latmod.mods.itemfilters.item.ItemMissing;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class QuestObjectBase {
    private static final Pattern TAG_PATTERN = Pattern.compile("^[a-z0-9_]*$");
    public int id = 0;
    public boolean invalid = false;
    public String title = "";
    public ItemStack icon = ItemStack.field_190927_a;
    private Set<String> tags = new LinkedHashSet<String>(0);
    private Icon cachedIcon = null;
    private String cachedTitle = null;
    private QuestObjectText cachedTextFile = null;

    public static boolean isNull(@Nullable QuestObjectBase object) {
        return object == null || object.invalid;
    }

    public static int getID(@Nullable QuestObjectBase object) {
        return QuestObjectBase.isNull(object) ? 0 : object.id;
    }

    public static String getCodeString(int id) {
        return String.format("%08x", id);
    }

    public static String getCodeString(@Nullable QuestObjectBase object) {
        return String.format("%08x", QuestObjectBase.getID(object));
    }

    public final String getCodeString() {
        return QuestObjectBase.getCodeString(this.id);
    }

    public final String toString() {
        return this.getCodeString();
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return this.id;
    }

    public abstract QuestObjectType getObjectType();

    public abstract QuestFile getQuestFile();

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean hasTag(String tag) {
        return !this.tags.isEmpty() && this.tags.contains(tag);
    }

    public void changeProgress(QuestData data, ChangeProgress type) {
    }

    public void forceProgress(QuestData data, ChangeProgress type, boolean notifications) {
        ChangeProgress.sendUpdates = false;
        ChangeProgress.sendNotifications = notifications ? EnumTristate.TRUE : EnumTristate.FALSE;
        this.changeProgress(data, type);
        ChangeProgress.sendUpdates = true;
        ChangeProgress.sendNotifications = EnumTristate.DEFAULT;
        this.getQuestFile().clearCachedProgress();
        if (!this.getQuestFile().isClient()) {
            new MessageChangeProgressResponse(data.getTeamUID(), this.id, type, notifications).sendToAll();
        }
        data.markDirty();
    }

    @Nullable
    public Chapter getQuestChapter() {
        return null;
    }

    public int getParentID() {
        return 1;
    }

    public void writeData(NBTTagCompound nbt) {
        if (!this.title.isEmpty()) {
            nbt.func_74778_a("title", this.title);
        }
        if (!this.icon.func_190926_b()) {
            nbt.func_74782_a("icon", ItemMissing.write((ItemStack)this.icon, (boolean)false));
        }
        if (!this.tags.isEmpty()) {
            NBTTagList tagList = new NBTTagList();
            for (String s : this.tags) {
                tagList.func_74742_a((NBTBase)new NBTTagString(s));
            }
            nbt.func_74782_a("tags", (NBTBase)tagList);
        }
    }

    public void readData(NBTTagCompound nbt) {
        this.title = nbt.func_74779_i("title");
        this.icon = ItemMissing.read((NBTBase)nbt.func_74781_a("icon"));
        NBTTagList tagsList = nbt.func_150295_c("tags", 8);
        this.tags = new LinkedHashSet<String>(tagsList.func_74745_c());
        for (int i = 0; i < tagsList.func_74745_c(); ++i) {
            this.tags.add(tagsList.func_150307_f(i));
        }
        if (nbt.func_74764_b("custom_id")) {
            this.tags.add(nbt.func_74779_i("custom_id"));
        }
    }

    public void writeNetData(DataOut data) {
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (!this.title.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)2, (!this.icon.func_190926_b() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)4, (!this.tags.isEmpty() ? 1 : 0) != 0);
        data.writeVarInt(flags);
        if (!this.title.isEmpty()) {
            data.writeString(this.title);
        }
        if (!this.icon.func_190926_b()) {
            data.writeItemStack(this.icon);
        }
        if (!this.tags.isEmpty()) {
            data.writeCollection(this.tags, DataOut.STRING);
        }
    }

    public void readNetData(DataIn data) {
        int flags = data.readVarInt();
        this.title = Bits.getFlag((int)flags, (int)1) ? data.readString() : "";
        this.icon = Bits.getFlag((int)flags, (int)2) ? data.readItemStack() : ItemStack.field_190927_a;
        this.tags = new LinkedHashSet<String>(0);
        if (Bits.getFlag((int)flags, (int)4)) {
            data.readCollection(this.tags, DataIn.STRING);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        config.addString("title", () -> this.title, v -> {
            this.title = v;
        }, "").setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.title", new Object[0])).setOrder(-127);
        config.add("icon", (ConfigValue)new ConfigItemStack.SimpleStack(() -> this.icon, v -> {
            this.icon = v;
        }), (ConfigValue)new ConfigItemStack(ItemStack.field_190927_a)).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.icon", new Object[0])).setOrder(-126);
        config.addList("tags", this.tags, (ConfigValue)new ConfigString("", TAG_PATTERN), value -> new ConfigString(value, TAG_PATTERN), ConfigString::getString).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.tags", new Object[0])).setOrder(-125);
    }

    public QuestObjectText loadText() {
        if (this.invalid || this.id == 0) {
            return QuestObjectText.NONE;
        }
        if (this.cachedTextFile == null) {
            File fileLang;
            String langCode;
            this.cachedTextFile = QuestObjectText.NONE;
            File file = new File(Loader.instance().getConfigDir(), "ftbquests/" + this.getQuestFile().folderName + "/text/en_us/" + QuestObjectBase.getCodeString(this) + ".txt");
            HashMap<String, String[]> text = new HashMap<String, String[]>();
            if (file.exists()) {
                String currentKey = "";
                ArrayList<String> currentText = new ArrayList<String>();
                for (String s : DataReader.get((File)file).safeStringList()) {
                    if (s.indexOf(91) == 0 && s.indexOf(93) == s.length() - 1) {
                        this.loadTextAdd(text, currentKey, currentText);
                        currentKey = s.substring(1, s.length() - 1);
                        continue;
                    }
                    currentText.add(s);
                }
                this.loadTextAdd(text, currentKey, currentText);
            }
            if (!(langCode = FTBQuests.PROXY.getLanguageCode()).equals("en_us") && (fileLang = new File(Loader.instance().getConfigDir(), "ftbquests/" + this.getQuestFile().folderName + "/text/" + langCode + "/" + QuestObjectBase.getCodeString(this) + ".txt")).exists()) {
                String currentKey = "";
                ArrayList<String> currentText = new ArrayList<String>();
                for (String s : DataReader.get((File)fileLang).safeStringList()) {
                    if (s.indexOf(91) == 0 && s.indexOf(93) == s.length() - 1) {
                        this.loadTextAdd(text, currentKey, currentText);
                        currentKey = s.substring(1, s.length() - 1);
                        continue;
                    }
                    currentText.add(s);
                }
                this.loadTextAdd(text, currentKey, currentText);
            }
            this.cachedTextFile = text.isEmpty() ? QuestObjectText.NONE : new QuestObjectText(text);
        }
        return this.cachedTextFile;
    }

    private void loadTextAdd(Map<String, String[]> text, String currentKey, List<String> currentText) {
        while (!currentText.isEmpty() && currentText.get(0).isEmpty()) {
            currentText.remove(0);
        }
        while (!currentText.isEmpty() && currentText.get(currentText.size() - 1).isEmpty()) {
            currentText.remove(currentText.size() - 1);
        }
        if (!currentText.isEmpty()) {
            text.put(currentKey, currentText.toArray(new String[0]));
            currentText.clear();
        }
    }

    public abstract Icon getAltIcon();

    public abstract String getAltTitle();

    public final Icon getIcon() {
        if (this.cachedIcon != null) {
            return this.cachedIcon;
        }
        if (!this.icon.func_190926_b()) {
            this.cachedIcon = this.icon.func_77973_b() == FTBQuestsItems.CUSTOM_ICON && this.icon.func_77942_o() ? Icon.getIcon((String)this.icon.func_77978_p().func_74779_i("icon")) : ItemIcon.getItemIcon((ItemStack)this.icon);
        }
        if (this.cachedIcon == null || this.cachedIcon.isEmpty()) {
            this.cachedIcon = (Icon)ThemeProperties.ICON.get(this);
        }
        if (this.cachedIcon.isEmpty()) {
            this.cachedIcon = this.getAltIcon();
        }
        return this.cachedIcon;
    }

    public final String getTitle() {
        if (this.cachedTitle != null) {
            return this.cachedTitle;
        }
        String textTitle = this.loadText().getString("title");
        if (!textTitle.isEmpty()) {
            this.cachedTitle = textTitle;
            return this.cachedTitle;
        }
        String key = String.format("quests.%08x.title", this.id);
        String t = FTBQuestsClient.addI18nAndColors(I18n.func_135052_a((String)key, (Object[])new Object[0]));
        this.cachedTitle = t.isEmpty() || key.equals(t) ? (!this.title.isEmpty() ? FTBQuestsClient.addI18nAndColors(this.title) : this.getAltTitle().trim()) : t;
        return this.cachedTitle;
    }

    public final String getUnformattedTitle() {
        return StringUtils.unformatted((String)this.getTitle());
    }

    public final String getYellowDisplayName() {
        return TextFormatting.YELLOW + this.getTitle();
    }

    public void deleteSelf() {
        this.getQuestFile().remove(this.id);
    }

    public void deleteChildren() {
    }

    @SideOnly(value=Side.CLIENT)
    public void editedFromGUI() {
        ClientQuestFile.INSTANCE.refreshGui();
    }

    public void onCreated() {
    }

    @Nullable
    public File getFile() {
        return null;
    }

    public void clearCachedData() {
        this.cachedIcon = null;
        this.cachedTitle = null;
        this.cachedTextFile = null;
    }

    public ConfigGroup createSubGroup(ConfigGroup group) {
        return group.getGroup(this.getObjectType().getId());
    }

    @SideOnly(value=Side.CLIENT)
    public void onEditButtonClicked() {
        ConfigGroup group = ConfigGroup.newGroup((String)"ftbquests");
        this.getConfig(this.createSubGroup(group));
        new GuiEditConfig(group, (group1, sender) -> new MessageEditObject(this).sendToServer()).openGui();
    }

    public int refreshJEI() {
        return 0;
    }
}

