/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import it.unimi.dsi.fastutil.ints.Int2ByteOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;

public abstract class QuestData {
    public final Int2ObjectOpenHashMap<TaskData> taskData = new Int2ObjectOpenHashMap();
    public final Map<UUID, IntOpenHashSet> claimedPlayerRewards = new HashMap<UUID, IntOpenHashSet>();
    public final IntOpenHashSet claimedTeamRewards = new IntOpenHashSet();
    public Int2ByteOpenHashMap progressCache = null;
    public Int2ByteOpenHashMap areDependenciesCompleteCache = null;

    protected QuestData() {
    }

    public abstract short getTeamUID();

    public abstract String getTeamID();

    public abstract ITextComponent getDisplayName();

    public abstract QuestFile getFile();

    public abstract List<? extends EntityPlayer> getOnlineMembers();

    public void markDirty() {
    }

    public TaskData getTaskData(Task task) {
        TaskData data = (TaskData)this.taskData.get(task.id);
        if (data == null) {
            return task.createData(this);
        }
        return data;
    }

    public String toString() {
        return this.getTeamID();
    }

    public void removeTask(Task task) {
        this.taskData.remove(task.id);
    }

    public void createTaskData(Task task) {
        this.taskData.put(task.id, (Object)task.createData(this));
    }

    public boolean isRewardClaimed(UUID player, Reward reward) {
        if (reward.isTeamReward()) {
            return this.claimedTeamRewards.contains(reward.id);
        }
        IntOpenHashSet rewards = this.claimedPlayerRewards.get(player);
        return rewards != null && rewards.contains(reward.id);
    }

    public void unclaimRewards(Collection<Reward> rewards) {
        for (Reward reward : rewards) {
            if (reward.isTeamReward()) {
                this.claimedTeamRewards.rem(reward.id);
                continue;
            }
            Iterator<IntOpenHashSet> iterator = this.claimedPlayerRewards.values().iterator();
            while (iterator.hasNext()) {
                IntOpenHashSet set = iterator.next();
                if (set == null || !set.rem(reward.id) || !set.isEmpty()) continue;
                iterator.remove();
            }
        }
        this.markDirty();
    }

    public boolean setRewardClaimed(UUID player, Reward reward) {
        if (reward.isTeamReward()) {
            if (this.claimedTeamRewards.add(reward.id)) {
                reward.quest.checkRepeatableQuests(this, player);
                return true;
            }
        } else {
            IntOpenHashSet set = this.claimedPlayerRewards.get(player);
            if (set == null) {
                set = new IntOpenHashSet();
            }
            if (set.add(reward.id)) {
                if (set.size() == 1) {
                    this.claimedPlayerRewards.put(player, set);
                }
                reward.quest.checkRepeatableQuests(this, player);
                return true;
            }
        }
        return false;
    }

    public void checkAutoCompletion(Quest quest) {
    }
}

