/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.net;

import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.net.FTBQuestsNetHandler;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageSyncQuests
extends MessageToClient {
    public QuestFile file;
    public short team;
    public Collection<TeamInst> teamData;
    public boolean editingMode;
    public UUID[] playerIDs;
    public short[] playerTeams;
    public int[] favorites;

    public NetworkWrapper getWrapper() {
        return FTBQuestsNetHandler.GENERAL;
    }

    public void writeData(DataOut data) {
        this.file.writeNetDataFull(data);
        data.writeShort((int)this.team);
        data.writeCollection(this.teamData, TeamInst.SERIALIZER);
        data.writeBoolean(this.editingMode);
        data.writeVarInt(this.playerIDs.length);
        for (int i = 0; i < this.playerIDs.length; ++i) {
            data.writeUUID(this.playerIDs[i]);
            data.writeShort((int)this.playerTeams[i]);
        }
        data.writeVarInt(this.favorites.length);
        for (int i : this.favorites) {
            data.writeInt(i);
        }
    }

    public void readData(DataIn data) {
        int i;
        this.file = new ClientQuestFile();
        this.file.readNetDataFull(data);
        this.team = data.readShort();
        this.teamData = data.readCollection(TeamInst.DESERIALIZER);
        this.editingMode = data.readBoolean();
        this.playerIDs = new UUID[data.readVarInt()];
        this.playerTeams = new short[this.playerIDs.length];
        for (i = 0; i < this.playerIDs.length; ++i) {
            this.playerIDs[i] = data.readUUID();
            this.playerTeams[i] = data.readShort();
        }
        this.favorites = new int[data.readVarInt()];
        for (i = 0; i < this.favorites.length; ++i) {
            this.favorites[i] = data.readInt();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        ((ClientQuestFile)this.file).load(this);
    }

    public static class TeamInst {
        public static final DataOut.Serializer<TeamInst> SERIALIZER = (data, t) -> {
            int i;
            data.writeShort((int)t.uid);
            data.writeString(t.id);
            data.writeTextComponent(t.name);
            data.writeVarInt(t.taskKeys.length);
            for (i = 0; i < t.taskKeys.length; ++i) {
                data.writeInt(t.taskKeys[i]);
                data.writeVarLong(t.taskValues[i]);
            }
            data.writeVarInt(t.playerRewardUUIDs.length);
            for (i = 0; i < t.playerRewardUUIDs.length; ++i) {
                data.writeUUID(t.playerRewardUUIDs[i]);
                data.writeVarInt(t.playerRewardIDs[i].length);
                int[] nArray = t.playerRewardIDs[i];
                int n = nArray.length;
                for (int j = 0; j < n; ++j) {
                    int j2 = nArray[j];
                    data.writeInt(j2);
                }
            }
            data.writeVarInt(t.teamRewards.length);
            for (int i2 : t.teamRewards) {
                data.writeInt(i2);
            }
        };
        public static final DataIn.Deserializer<TeamInst> DESERIALIZER = data -> {
            int i;
            TeamInst t = new TeamInst();
            t.uid = data.readShort();
            t.id = data.readString();
            t.name = data.readTextComponent();
            t.taskKeys = new int[data.readVarInt()];
            t.taskValues = new long[t.taskKeys.length];
            for (i = 0; i < t.taskKeys.length; ++i) {
                t.taskKeys[i] = data.readInt();
                t.taskValues[i] = data.readVarLong();
            }
            t.playerRewardUUIDs = new UUID[data.readVarInt()];
            t.playerRewardIDs = new int[t.playerRewardUUIDs.length][];
            for (i = 0; i < t.playerRewardUUIDs.length; ++i) {
                t.playerRewardUUIDs[i] = data.readUUID();
                t.playerRewardIDs[i] = new int[data.readVarInt()];
                for (int j = 0; j < t.playerRewardIDs[i].length; ++j) {
                    t.playerRewardIDs[i][j] = data.readInt();
                }
            }
            t.teamRewards = new int[data.readVarInt()];
            for (i = 0; i < t.teamRewards.length; ++i) {
                t.teamRewards[i] = data.readInt();
            }
            return t;
        };
        public short uid;
        public String id;
        public ITextComponent name;
        public int[] taskKeys;
        public long[] taskValues;
        public UUID[] playerRewardUUIDs;
        public int[][] playerRewardIDs;
        public int[] teamRewards;
    }
}

