/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.customnpcs;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.integration.customnpcs.CustomNPCsIntegration;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.task.BooleanTaskData;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.ftbquests.util.NumberMode;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.controllers.data.PlayerData;

public class NPCFactionTask
extends Task {
    public int npcFaction = 0;
    public int requiredPoints = 1;
    public NumberMode mode = NumberMode.GREATER_THAN_OR_EQUAL;

    public NPCFactionTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return CustomNPCsIntegration.FACTION_TASK;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74768_a("npc_faction", this.npcFaction);
        nbt.func_74768_a("required_points", this.requiredPoints);
        nbt.func_74778_a("point_mode", this.mode.getId());
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.npcFaction = nbt.func_74762_e("npc_faction");
        this.requiredPoints = nbt.func_74762_e("required_points");
        this.mode = (NumberMode)((Object)NumberMode.NAME_MAP.get(nbt.func_74779_i("point_mode")));
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarInt(this.npcFaction);
        data.writeVarInt(this.requiredPoints);
        NumberMode.NAME_MAP.write(data, (Object)this.mode);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.npcFaction = data.readVarInt();
        this.requiredPoints = data.readVarInt();
        this.mode = (NumberMode)((Object)NumberMode.NAME_MAP.read(data));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("id", () -> this.npcFaction, v -> {
            this.npcFaction = v;
        }, 0, 0, Integer.MAX_VALUE);
        config.addInt("required_points", () -> this.requiredPoints, v -> {
            this.requiredPoints = v;
        }, 1, 0, Integer.MAX_VALUE);
        config.addEnum("mode", () -> this.mode, v -> {
            this.mode = v;
        }, NumberMode.NAME_MAP);
    }

    @Override
    public TaskData createData(QuestData data) {
        return new Data(this, data);
    }

    public static class Data
    extends BooleanTaskData<NPCFactionTask> {
        private Data(NPCFactionTask task, QuestData data) {
            super(task, data);
        }

        @Override
        public boolean canSubmit(EntityPlayerMP player) {
            PlayerData data;
            PlayerData playerData = data = ((NPCFactionTask)this.task).npcFaction > 0 ? PlayerData.get((EntityPlayer)player) : null;
            if (data != null && data.factionData.factionData.containsKey(((NPCFactionTask)this.task).npcFaction)) {
                return ((NPCFactionTask)this.task).mode.check(data.factionData.getFactionPoints((EntityPlayer)player, ((NPCFactionTask)this.task).npcFaction), ((NPCFactionTask)this.task).requiredPoints);
            }
            return false;
        }
    }
}

