/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.command;

import com.feed_the_beast.ftblib.lib.config.EnumTristate;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.command.CommandFTBQuestsBase;
import com.feed_the_beast.ftbquests.net.edit.MessageCreateObjectResponse;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.task.ItemTask;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;

public class CommandGenerateItemChapter
extends CommandFTBQuestsBase {
    public String func_71517_b() {
        return "generate_chapter_with_all_items_in_game";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        NonNullList list = NonNullList.func_191196_a();
        for (Item item : Item.field_150901_e) {
            try {
                item.func_150895_a(CreativeTabs.field_78027_g, list);
            }
            catch (Throwable ex) {
                FTBQuests.LOGGER.warn("Failed to get items from " + item.getRegistryName() + ": " + ex);
            }
        }
        Chapter chapter = new Chapter(ServerQuestFile.INSTANCE);
        chapter.id = chapter.file.newID();
        chapter.onCreated();
        chapter.title = "Generated chapter of all items in search creative tab [" + list.size() + "]";
        chapter.icon = new ItemStack(Items.field_151111_aL);
        new MessageCreateObjectResponse(chapter, null).sendToAll();
        FTBQuests.LOGGER.info("Found " + list.size() + " items in total, chapter ID: " + chapter);
        for (int i = 0; i < list.size(); ++i) {
            Quest quest = new Quest(chapter);
            quest.id = chapter.file.newID();
            quest.onCreated();
            quest.x = i % 40;
            quest.y = i / 40;
            quest.subtitle = ((ItemStack)list.get(i)).serializeNBT().toString();
            new MessageCreateObjectResponse(quest, null).sendToAll();
            ItemTask task = new ItemTask(quest);
            task.id = chapter.file.newID();
            task.onCreated();
            task.consumeItems = EnumTristate.TRUE;
            task.items.add((ItemStack)list.get(i));
            NBTTagCompound extra = new NBTTagCompound();
            extra.func_74778_a("type", task.getType().getTypeForNBT());
            new MessageCreateObjectResponse(task, extra).sendToAll();
        }
        ServerQuestFile.INSTANCE.save();
        ServerQuestFile.INSTANCE.saveNow();
    }
}

