/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.common.lib;

import cpw.mods.ironchest.common.tileentity.shulker.TileEntityIronShulkerBox;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ICShulkerInventoryHandler
implements IItemHandlerModifiable {
    TileEntityIronShulkerBox inv;

    public ICShulkerInventoryHandler(TileEntityIronShulkerBox inventory) {
        this.inv = inventory;
    }

    public int getSlots() {
        return this.inv.func_70302_i_();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inv.func_70301_a(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return stack;
        }
        if (!this.inv.func_94041_b(slot, stack)) {
            return stack;
        }
        int offsetSlot = slot;
        ItemStack currentStack = (ItemStack)this.inv.func_190576_q().get(offsetSlot);
        if (currentStack.func_190926_b()) {
            int accepted = Math.min(stack.func_77976_d(), this.inv.func_70297_j_());
            if (accepted < stack.func_190916_E()) {
                if (!simulate) {
                    this.inv.func_190576_q().set(offsetSlot, (Object)stack.func_77979_a(accepted));
                    this.inv.func_70296_d();
                    return stack;
                }
                stack.func_190918_g(accepted);
                return stack;
            }
            if (!simulate) {
                this.inv.func_190576_q().set(offsetSlot, (Object)stack);
                this.inv.func_70296_d();
            }
            return ItemStack.field_190927_a;
        }
        int accepted = Math.min(stack.func_77976_d(), this.inv.func_70297_j_()) - currentStack.func_190916_E();
        if (accepted <= 0 || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)currentStack)) {
            return stack;
        }
        if (accepted < stack.func_190916_E()) {
            if (!simulate) {
                ItemStack newStack = stack.func_77979_a(accepted);
                newStack.func_190917_f(currentStack.func_190916_E());
                this.inv.func_190576_q().set(offsetSlot, (Object)newStack);
                this.inv.func_70296_d();
                return stack;
            }
            stack.func_190918_g(accepted);
            return stack;
        }
        if (!simulate) {
            ItemStack newStack = stack.func_77946_l();
            newStack.func_190917_f(currentStack.func_190916_E());
            this.inv.func_190576_q().set(offsetSlot, (Object)newStack);
            this.inv.func_70296_d();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        int offsetSlot = slot;
        ItemStack currentStack = (ItemStack)this.inv.func_190576_q().get(offsetSlot);
        if (currentStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int extracted = Math.min(currentStack.func_190916_E(), amount);
        ItemStack copy = currentStack.func_77946_l();
        copy.func_190920_e(extracted);
        if (!simulate) {
            if (extracted < currentStack.func_190916_E()) {
                currentStack.func_190918_g(extracted);
            } else {
                currentStack = ItemStack.field_190927_a;
            }
            this.inv.func_190576_q().set(offsetSlot, (Object)currentStack);
            this.inv.func_70296_d();
        }
        return copy;
    }

    public int getSlotLimit(int slot) {
        return this.getInv().func_70297_j_();
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.inv.func_190576_q().set(slot, (Object)stack);
        this.inv.func_70296_d();
    }

    public IInventory getInv() {
        return this.inv;
    }
}

